/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.tempvis;

import edu.iu.sci2.visualization.scimaps.tempvis.RenderableVisualization;
import edu.iu.sci2.visualization.scimaps.tempvis.VisualizationPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import org.freehep.util.export.ExportDialog;

public class VisualizationRunner {
    public static final String PAUSE_RESUME_BUTTON_COMMAND = "pause/resume";
    public static final String ENABLE_DISABLE_SCALING_CHECK_BOX_COMMAND = "enable/disable scaling";
    private RenderableVisualization visualization;
    private VisualizationPanel visualizationPanel;
    private JScrollPane containerPanel;
    private JFrame frame;

    public VisualizationRunner(RenderableVisualization visualization) {
        this.visualization = visualization;
        this.visualizationPanel = new VisualizationPanel(visualization);
        this.containerPanel = new JScrollPane(this.visualizationPanel, 20, 30);
    }

    public void setUp() {
        this.tearDown();
        this.frame = new JFrame(this.visualization.title());
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().add(this.createContentPane());
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        JMenu file = new JMenu("File");
        menuBar.add(file);
        JMenuItem exportItem = new JMenuItem("Export...");
        exportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog export = new ExportDialog();
                export.showExportDialog((Component)VisualizationRunner.this.getContainerPanel(), "Export view as ...", (Component)VisualizationRunner.this.getVisualizationPanel(), "export");
            }
        });
        file.add(exportItem);
        JMenuItem quitItem = new JMenuItem("Quit");
        quitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizationRunner.this.getFrame().dispose();
            }
        });
        file.add(quitItem);
    }

    public void run() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void tearDown() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    protected JFrame getFrame() {
        return this.frame;
    }

    protected JScrollPane getContainerPanel() {
        return this.containerPanel;
    }

    protected VisualizationPanel getVisualizationPanel() {
        return this.visualizationPanel;
    }

    private Component createContentPane() {
        return this.containerPanel;
    }
}

