/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.scimaps.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import java.io.Closeable;
import java.io.IOException;

public final class TextualMaps {
    private TextualMaps() {
    }

    public static <R extends Readable & Closeable> ImmutableMap<String, String> buildMapFromLinesOfEntries(InputSupplier<R> inputSupplier, Splitter keyValueSplitter) throws IOException {
        Preconditions.checkNotNull(inputSupplier);
        Preconditions.checkNotNull((Object)keyValueSplitter);
        return (ImmutableMap)CharStreams.readLines(inputSupplier, (LineProcessor)new MapEntryLineProcessor(keyValueSplitter));
    }

    private static final class MapEntryLineProcessor
    implements LineProcessor<ImmutableMap<String, String>> {
        private final Splitter keyValueSplitter;
        private final ImmutableMap.Builder<String, String> builder;

        private MapEntryLineProcessor(Splitter keyValueSplitter) {
            this.keyValueSplitter = (Splitter)Preconditions.checkNotNull((Object)keyValueSplitter);
            this.builder = ImmutableMap.builder();
        }

        public boolean processLine(String line) throws IOException {
            Iterable tokens = this.keyValueSplitter.split((CharSequence)line);
            Preconditions.checkArgument((Iterables.size((Iterable)tokens) == 2 ? 1 : 0) != 0, (String)"Line \"%s\" contains %s tokens (%s) but exactly two were expected.", (Object[])new Object[]{line, Iterables.size((Iterable)tokens), Iterables.toString((Iterable)tokens)});
            String key = (String)Iterables.get((Iterable)tokens, (int)0);
            String value = (String)Iterables.get((Iterable)tokens, (int)1);
            this.builder.put((Object)key, (Object)value);
            return true;
        }

        private ImmutableMap<String, String> buildMap() {
            return this.builder.build();
        }

        public ImmutableMap<String, String> getResult() {
            ImmutableMap<String, String> map = this.buildMap();
            return map;
        }
    }
}

