/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.common;

import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPostscriptDocument;
import edu.iu.sci2.visualization.temporalbargraph.common.PageElement;
import edu.iu.sci2.visualization.temporalbargraph.web.WebTemporalBarGraphPages;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public abstract class AbstractPages {
    protected static final StringTemplateGroup utilitiesGroup = new StringTemplateGroup((Reader)new InputStreamReader(WebTemporalBarGraphPages.class.getResourceAsStream("/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/utilities.st")));
    protected static final StringTemplateGroup pageElementsGroup = new StringTemplateGroup((Reader)new InputStreamReader(WebTemporalBarGraphPages.class.getResourceAsStream("/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/page_elements.st")));
    public static final String UTILITIES_STRING_TEMPLATE_FILE_PATH = "/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/utilities.st";
    public static final String PAGE_ELEMENTS_STRING_TEMPLATE_FILE_PATH = "/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/page_elements.st";
    private List<PageElement> pageElementsAllPages = new ArrayList<PageElement>();
    private Map<Integer, List<PageElement>> pageElementsSomePages = new TreeMap<Integer, List<PageElement>>();
    private boolean pageElementsAdded = false;

    public String renderDefinitionsPostscript() {
        if (!this.pageElementsAdded) {
            this.addPageElements();
            this.pageElementsAdded = true;
        }
        HashSet<String> definitionsSet = new HashSet<String>();
        definitionsSet.add(utilitiesGroup.getInstanceOf("pageUtilityDefinitions").toString());
        HashSet<PageElement> allPageElements = new HashSet<PageElement>();
        allPageElements.addAll(this.getPageElementsAllPages());
        for (List<PageElement> elements : this.getPageElementsSomePages().values()) {
            allPageElements.addAll(elements);
        }
        for (PageElement element : allPageElements) {
            definitionsSet.add(element.renderDefinitionsPostscript());
        }
        StringBuilder definitions = new StringBuilder();
        for (String definition : definitionsSet) {
            definitions.append(definition);
        }
        return definitions.toString();
    }

    public List<String> renderPagesIndividuallyPostScript() {
        ArrayList<String> pages = new ArrayList<String>();
        int ii = 0;
        while (ii < this.numberOfPages()) {
            pages.add(this.renderPagePostscript(ii));
            ++ii;
        }
        return pages;
    }

    public String renderPagesPostscript() {
        if (!this.pageElementsAdded) {
            this.addPageElements();
            this.pageElementsAdded = true;
        }
        StringBuilder pagesPostScript = new StringBuilder();
        pagesPostScript.append(this.renderDefinitionsPostscript());
        int ii = 0;
        while (ii < this.numberOfPages()) {
            StringTemplate pageSetupTemplate = AbstractPostscriptDocument.documentGroup.getInstanceOf("pageSetup");
            pageSetupTemplate.setAttribute("pageNumber", ii + 1);
            pagesPostScript.append(pageSetupTemplate.toString());
            pagesPostScript.append(this.renderPagePostscript(ii));
            StringTemplate pageTearDownTemplate = AbstractPostscriptDocument.documentGroup.getInstanceOf("pageTearDown");
            pagesPostScript.append(pageTearDownTemplate.toString());
            ++ii;
        }
        return pagesPostScript.toString();
    }

    protected String renderPagePostscript(int pageNumber) {
        StringBuilder pagePostScript = new StringBuilder();
        for (PageElement element : this.getPageElementsAllPages()) {
            pagePostScript.append(element.renderPostscript());
        }
        for (PageElement element : this.getPageElementsSomePages(pageNumber)) {
            pagePostScript.append(element.renderPostscript());
        }
        return pagePostScript.toString();
    }

    protected List<PageElement> getPageElementsSomePages(int pageNumber) {
        return this.pageElementsSomePages.get(pageNumber);
    }

    protected Map<Integer, List<PageElement>> getPageElementsSomePages() {
        return this.pageElementsSomePages;
    }

    protected List<PageElement> getPageElementsAllPages() {
        return this.pageElementsAllPages;
    }

    protected List<PageElement> setElementsForPage(int pageNumber, List<PageElement> elements) {
        return this.pageElementsSomePages.put(pageNumber, elements);
    }

    protected void addElementsAllPages(List<PageElement> elements) {
        for (PageElement element : elements) {
            this.addPageElementAllPages(element);
        }
    }

    protected void addPageElementAllPages(PageElement element) {
        this.pageElementsAllPages.add(element);
    }

    protected void addPageElementSomePages(PageElement element, List<Integer> pages) {
        for (int pageNumber : pages) {
            this.addElementForPage(pageNumber, element);
        }
    }

    protected void addPageElementsSomePages(Map<Integer, List<PageElement>> pageToElements) {
        for (int pageNumber : pageToElements.keySet()) {
            for (PageElement element : pageToElements.get(pageNumber)) {
                this.addElementForPage(pageNumber, element);
            }
        }
    }

    protected void addElementForPage(int pageNumber, PageElement element) {
        List<PageElement> elements = this.getPageElementsSomePages(pageNumber);
        if (elements == null) {
            elements = new ArrayList<PageElement>();
        }
        elements.add(element);
        this.setElementsForPage(pageNumber, elements);
    }

    protected abstract int numberOfPages();

    public abstract void addPageElements();
}

