/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.common;

import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPages;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.joda.time.LocalDate;

public abstract class AbstractPostscriptDocument {
    public static final String DOCUMENT_STRING_TEMPLATE_FILE_PATH = "/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/document.st";
    public static final StringTemplateGroup documentGroup = new StringTemplateGroup((Reader)new InputStreamReader(AbstractPostscriptDocument.class.getResourceAsStream("/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/document.st")));

    protected abstract AbstractPages getPages();

    protected abstract DoubleDimension getPageSize();

    public String renderPostscript() {
        StringBuilder documentPostScript = new StringBuilder();
        documentPostScript.append(this.renderHeader());
        documentPostScript.append(AbstractPostscriptDocument.renderProcedureDefinitions());
        documentPostScript.append(this.renderDocumentSetup());
        documentPostScript.append(AbstractPostscriptDocument.renderPages(this.getPages()));
        documentPostScript.append(AbstractPostscriptDocument.renderDocumentTrailer());
        return documentPostScript.toString();
    }

    protected String renderHeader() {
        StringTemplate headerTemplate = AbstractPostscriptDocument.getGroup().getInstanceOf("header");
        headerTemplate.setAttribute("numberOfPages", this.getPages().numberOfPages());
        headerTemplate.setAttribute("date", (Object)new LocalDate().toString());
        return headerTemplate.toString();
    }

    protected static String renderProcedureDefinitions() {
        StringTemplate procedureDefinitionsTemplate = AbstractPostscriptDocument.getGroup().getInstanceOf("procedureDefinitions");
        return procedureDefinitionsTemplate.toString();
    }

    protected String renderDocumentSetup() {
        StringTemplate documentSetupTemplate = AbstractPostscriptDocument.getGroup().getInstanceOf("documentSetup");
        documentSetupTemplate.setAttribute("pageWidth", (Object)this.getPageSize().getWidth());
        documentSetupTemplate.setAttribute("pageHeight", (Object)this.getPageSize().getHeight());
        return documentSetupTemplate.toString();
    }

    protected static String renderPages(AbstractPages pages) {
        StringBuilder pagePostcript = new StringBuilder();
        pagePostcript.append(pages.renderDefinitionsPostscript());
        List<String> individualPages = pages.renderPagesIndividuallyPostScript();
        int ii = 0;
        while (ii < individualPages.size()) {
            StringTemplate pageSetupTemplate = documentGroup.getInstanceOf("pageSetup");
            pageSetupTemplate.setAttribute("pageNumber", ii + 1);
            pagePostcript.append(pageSetupTemplate.toString());
            pagePostcript.append(individualPages.get(ii));
            StringTemplate pageTearDownTemplate = documentGroup.getInstanceOf("pageTearDown");
            pagePostcript.append(pageTearDownTemplate.toString());
            ++ii;
        }
        return pagePostcript.toString();
    }

    protected static String renderDocumentTrailer() {
        StringTemplate documentTrailerTemplate = AbstractPostscriptDocument.getGroup().getInstanceOf("documentTrailer");
        return documentTrailerTemplate.toString();
    }

    protected static StringTemplateGroup getGroup() {
        return documentGroup;
    }
}

