/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.common;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.io.Files;
import edu.iu.sci2.visualization.temporalbargraph.common.InvalidRecordException;
import edu.iu.sci2.visualization.temporalbargraph.common.PostScriptCreationException;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Table;
import prefuse.data.Tuple;

public abstract class AbstractTemporalBarGraphAlgorithm
implements Algorithm {
    public static final String POSTSCRIPT_MIME_TYPE = "file:text/ps";
    public static final String CSV_MIME_TYPE = "file:text/csv";
    public static final String PS_FILE_SUFFIX = ".ps";
    public static final String CSV_FILE_SUFFIX = ".csv";

    public Data[] execute() throws AlgorithmExecutionException {
        LogService logger = this.getLogger();
        Data inputData = this.getInputData();
        logger.log(3, "Creating PostScript..");
        CSVWriter csvWriter = null;
        try {
            File barSizesFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"barSizes", (String)CSV_FILE_SUFFIX);
            csvWriter = new CSVWriter((Writer)new FileWriter(barSizesFile));
            String[] header = new String[]{"Record Name", "Width", "Height", "Area (Width x Height)"};
            csvWriter.writeNext(header);
            String postScriptCode = this.createPostScriptCode(csvWriter);
            csvWriter.close();
            File temporaryPostScriptFile = AbstractTemporalBarGraphAlgorithm.writePostScriptCodeToTemporaryFile(postScriptCode, "horizontal-line-graph");
            Data[] dataArray = AbstractTemporalBarGraphAlgorithm.formOutData(temporaryPostScriptFile, barSizesFile, inputData);
            return dataArray;
        }
        catch (IOException e) {
            String message = String.format("An error occurred when creating %s.", AbstractTemporalBarGraphAlgorithm.getLabel(inputData.getMetadata()));
            message = String.valueOf(message) + e.getMessage();
            throw new AlgorithmExecutionException(message, (Throwable)e);
        }
        catch (PostScriptCreationException e) {
            String exceptionMessage = String.format("An error occurred when creating the PostScript for the %s.", String.valueOf(AbstractTemporalBarGraphAlgorithm.getLabel(inputData.getMetadata())) + e.getMessage());
            throw new AlgorithmExecutionException(exceptionMessage, (Throwable)e);
        }
        finally {
            if (csvWriter != null) {
                try {
                    csvWriter.close();
                }
                catch (IOException e) {
                    throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected abstract LogService getLogger();

    protected abstract Data getInputData();

    protected abstract String createPostScriptCode(CSVWriter var1) throws PostScriptCreationException;

    private static File writePostScriptCodeToTemporaryFile(String postScriptCode, String temporaryFileName) throws IOException {
        File psFile = File.createTempFile(temporaryFileName, PS_FILE_SUFFIX);
        psFile.deleteOnExit();
        Files.write((CharSequence)postScriptCode, (File)psFile, (Charset)Charset.defaultCharset());
        return psFile;
    }

    private static Data[] formOutData(File postScriptFile, File barSizesFile, Data inputData) {
        BasicData postScriptData = new BasicData((Object)postScriptFile, POSTSCRIPT_MIME_TYPE);
        Dictionary postScriptMetaData = postScriptData.getMetadata();
        postScriptMetaData.put("Label", "visualized with Temporal Bar Graph");
        postScriptMetaData.put("Parent", inputData);
        postScriptMetaData.put("Type", "Vector Image");
        BasicData barSizesData = new BasicData((Object)barSizesFile, CSV_MIME_TYPE);
        Dictionary barSizesMetadata = barSizesData.getMetadata();
        barSizesMetadata.put("Label", "bar sizes");
        barSizesMetadata.put("Parent", inputData);
        barSizesMetadata.put("Type", "Table");
        return new Data[]{postScriptData, barSizesData};
    }

    private static String getLabel(Dictionary<String, Object> metadata) {
        Object label = metadata.get("Label");
        if (label != null) {
            return String.format("data \"%s\"", label.toString());
        }
        return "input data";
    }

    protected static List<Record> readRecordsFromTable(Table table, LogService logger, String labelColumn, String startDateColumn, String endDateColumn, String sizeByColumn, String startDateFormat, String endDateFormat, String categoryColumn) {
        ArrayList<Record> workingRecordSet = new ArrayList<Record>();
        Iterator rows = table.tuples();
        while (rows.hasNext()) {
            Tuple row = (Tuple)rows.next();
            try {
                Record newRecord = new Record(row, labelColumn, startDateColumn, endDateColumn, sizeByColumn, startDateFormat, endDateFormat, categoryColumn);
                workingRecordSet.add(newRecord);
            }
            catch (InvalidRecordException e) {
                logger.log(2, "A record was ignored: " + e.getMessage(), (Throwable)e);
            }
        }
        return workingRecordSet;
    }
}

