/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.common;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractTemporalBarGraphAlgorithmFactory;
import edu.iu.sci2.visualization.temporalbargraph.common.PostScriptBar;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import java.awt.Color;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.cishell.utilities.MapUtilities;
import org.cishell.utilities.color.ColorRegistry;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public abstract class AbstractVisualization {
    protected static final int MAX_LINEDATES = 15;
    protected static final int MAX_BARS_PER_PAGE = 50;
    public static final int MAX_LABEL_FONT_SIZE = 12;
    public static final int LABEL_BAR_SPACING = 15;
    public static final String STRING_TEMPLATE_FILE_PATH = "/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/visualization.st";
    public static final StringTemplateGroup group = new StringTemplateGroup((Reader)new InputStreamReader(AbstractTemporalBarGraphAlgorithmFactory.class.getResourceAsStream("/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/visualization.st")));
    protected static final Function<PostScriptBar, Double> AMOUNT_PER_DAY_GETTER = new Function<PostScriptBar, Double>(){

        public Double apply(PostScriptBar bar) {
            return bar.amountPerDay();
        }
    };

    protected static List<DateTime> getYearTicks(DateTime startDate, DateTime endDate, int maxDateLines) {
        Preconditions.checkArgument((startDate.compareTo((Object)endDate) < 0 ? 1 : 0) != 0, (Object)"The start date must be before the end date!");
        Preconditions.checkArgument((maxDateLines > 2 ? 1 : 0) != 0, (Object)"MAX_DATES must be greater than 2");
        LinkedList<DateTime> yearTicks = new LinkedList<DateTime>();
        int startYear = startDate.toLocalDate().getYear();
        int endYear = endDate.toLocalDate().getYear() + 1;
        int difference = endYear - startYear;
        double yearsPerStep = (double)difference / (double)maxDateLines;
        if (yearsPerStep < 1.0) {
            int year = startYear;
            while (year <= endYear) {
                yearTicks.add(new LocalDate(year, 1, 1).toDateTimeAtStartOfDay());
                ++year;
            }
        } else {
            int step = (int)Math.ceil(yearsPerStep);
            int i = 0;
            while (i <= maxDateLines) {
                int year = i * step + startYear;
                yearTicks.add(new LocalDate(year, 1, 1).toDateTimeAtStartOfDay());
                if (year < endYear) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        assert (yearTicks.size() >= 2);
        assert (((DateTime)yearTicks.get(yearTicks.size() - 1)).getYear() >= endYear);
        assert (((DateTime)yearTicks.get(0)).getYear() == startYear);
        return yearTicks;
    }

    protected static List<List<PostScriptBar>> splitBars(List<PostScriptBar> bars, int maxBarsPerPage) {
        assert (maxBarsPerPage > 0);
        int pagesRequired = (int)Math.ceil((float)bars.size() / (float)maxBarsPerPage);
        int actualBarsPerPage = (int)Math.ceil((float)bars.size() / (float)pagesRequired);
        return Lists.partition(bars, (int)actualBarsPerPage);
    }

    protected abstract String getVisualizationArea(List<PostScriptBar> var1);

    protected static double getTotalAmountPerDay(List<PostScriptBar> bars) {
        double totalAmountPerDay = 0.0;
        for (PostScriptBar bar : bars) {
            totalAmountPerDay += bar.amountPerDay();
        }
        return totalAmountPerDay;
    }

    protected static List<PostScriptBar> createBars(List<Record> records, CSVWriter csvWriter, DateTime startDate, ColorRegistry<String> colorRegistry) {
        ArrayList<PostScriptBar> bars = new ArrayList<PostScriptBar>(records.size());
        AbstractVisualization.prepareColorsRankedByCategoryTotal(records, colorRegistry);
        for (Record record : records) {
            int daysBetweenStartAndStop = Days.daysBetween((ReadableInstant)record.getStartDate(), (ReadableInstant)record.getEndDate()).getDays();
            if (daysBetweenStartAndStop == 0) {
                daysBetweenStartAndStop = Days.daysBetween((ReadableInstant)record.getStartDate(), (ReadableInstant)record.getStartDate().plusYears(1)).getDays();
                assert (daysBetweenStartAndStop > 0);
            }
            double area = record.getAmount();
            double amountPerDay = area / (double)daysBetweenStartAndStop;
            Color barColor = record.getCategory().equals(Record.Category.DEFAULT.toString()) ? colorRegistry.getDefaultColor() : colorRegistry.getColorOf((Object)record.getCategory());
            double daysSinceEarliest = Days.daysBetween((ReadableInstant)startDate, (ReadableInstant)record.getStartDate()).getDays();
            PostScriptBar psBar = new PostScriptBar(daysSinceEarliest, daysBetweenStartAndStop, amountPerDay, record, barColor);
            String[] bar = new String[]{psBar.getName(), Double.toString(psBar.lengthInDays()), Double.toString(psBar.amountPerDay()), Double.toString(psBar.getArea())};
            csvWriter.writeNext(bar);
            bars.add(psBar);
        }
        return bars;
    }

    private static void prepareColorsRankedByAmount(List<Record> records, ColorRegistry<String> colorRegistry) {
        if (colorRegistry.getKeySet().size() > 0) {
            throw new IllegalArgumentException("The color registry has already been initialized.");
        }
        HashMap<String, Double> categoryToAmount = new HashMap<String, Double>();
        for (Record record : records) {
            String category = record.getCategory();
            Double amount = (Double)categoryToAmount.get(record.getCategory());
            amount = amount == null ? Double.valueOf(record.getAmount()) : Double.valueOf(amount + record.getAmount());
            categoryToAmount.put(category, amount);
        }
        ImmutableList categoriesSortedByAmount = Ordering.natural().reverse().onResultOf(Functions.forMap(categoryToAmount)).immutableSortedCopy(categoryToAmount.keySet());
        for (String category : categoriesSortedByAmount) {
            colorRegistry.getColorOf((Object)category);
        }
    }

    private static void prepareColorsRankedByCategoryTotal(List<Record> records, ColorRegistry<String> colorRegistry) {
        if (colorRegistry.getKeySet().size() > 0) {
            throw new IllegalArgumentException("The color registry has already been initialized.");
        }
        ArrayList<String> categories = new ArrayList<String>();
        for (Record record : records) {
            categories.add(record.getCategory());
        }
        Map categoryCount = MapUtilities.keysToCounts(categories);
        ImmutableList categoriesSortedByCount = Ordering.natural().reverse().onResultOf(Functions.forMap((Map)categoryCount)).immutableSortedCopy(categoryCount.keySet());
        for (String category : categoriesSortedByCount) {
            colorRegistry.getColorOf((Object)category);
        }
    }

    protected static double getTopNDeltaYSum(List<PostScriptBar> bars, int barsPerPage) {
        ImmutableList deltaYs = ImmutableList.copyOf((Collection)Collections2.transform(bars, AMOUNT_PER_DAY_GETTER));
        List greatestDeltaYs = Ordering.natural().greatestOf((Iterable)deltaYs, barsPerPage);
        return AbstractVisualization.sum(greatestDeltaYs);
    }

    private static double sum(Iterable<? extends Double> doubles) {
        double total = 0.0;
        Iterator<? extends Double> iterator = doubles.iterator();
        while (iterator.hasNext()) {
            double d = iterator.next();
            total += d;
        }
        return total;
    }

    public abstract String renderDefinitionsPostscript();

    public abstract String renderVisualizationPostscript(int var1);

    public abstract int numberOfVisualizations();

    public abstract double minRecordValue();

    public abstract double maxRecordValue();
}

