/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.common;

import com.google.common.collect.Lists;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractTemporalBarGraphAlgorithmFactory;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import java.awt.Color;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.cishell.utilities.color.ColorRegistry;

public class CategoryBreakdown {
    List<Category> categories;
    private int columnSize;
    private int categorySize;
    private int numberOfColumns;
    private List<Column> columnBreakdown;
    public static final String STRING_TEMPLATE_FILE_PATH = "/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/category_breakdown.st";
    public static final StringTemplateGroup group = new StringTemplateGroup((Reader)new InputStreamReader(AbstractTemporalBarGraphAlgorithmFactory.class.getResourceAsStream("/edu/iu/sci2/visualization/temporalbargraph/common/stringtemplates/category_breakdown.st")));

    public CategoryBreakdown(List<Record> records, ColorRegistry<String> colorRegistry, int numberOfColumns, int columnSize, int categorySize) {
        if (columnSize < categorySize) {
            throw new IllegalArgumentException("The column must be large enough for atleast one category!");
        }
        this.numberOfColumns = numberOfColumns;
        this.columnSize = columnSize;
        this.categorySize = categorySize;
        TreeMap<String, Category> categoryNameToCategory = new TreeMap<String, Category>();
        for (Record record : records) {
            if (record.getCategory() == Record.Category.DEFAULT.toString()) continue;
            Category category = (Category)categoryNameToCategory.get(record.getCategory());
            if (category == null) {
                category = new Category(record.getCategory(), colorRegistry.getColorOf((Object)record.getCategory()), colorRegistry.getDefaultColor());
                categoryNameToCategory.put(category.getName(), category);
            }
            category.addMember(record);
        }
        this.categories = new ArrayList(categoryNameToCategory.values());
        this.columnBreakdown = this.breakIntoPostscriptColumns();
    }

    public int numberOfPages() {
        return Double.valueOf(Math.ceil((double)this.columnBreakdown.size() / (double)this.numberOfColumns)).intValue();
    }

    public String renderPostscript(int pageNumber) {
        if (pageNumber > this.numberOfPages()) {
            throw new IllegalArgumentException("The page number '" + pageNumber + "' is out of bounds.");
        }
        int firstColumnIndex = this.numberOfColumns * pageNumber;
        int finalColumnIndex = Math.min(firstColumnIndex + this.numberOfColumns, this.columnBreakdown.size());
        ArrayList<Column> columns = new ArrayList<Column>(this.columnBreakdown.subList(firstColumnIndex, finalColumnIndex));
        StringBuilder columnPostscript = new StringBuilder();
        for (Column column : columns) {
            for (Category category : Lists.reverse(column.getCategories())) {
                columnPostscript.append(String.format("(%s) %f %f %f ", category.getName(), (double)category.getColor().getRed() / 255.0, (double)category.getColor().getGreen() / 255.0, (double)category.getColor().getBlue() / 255.0));
            }
            columnPostscript.append(String.valueOf(column.getCategories().size()) + " ").append(String.valueOf(columns.indexOf(column)) + " ").append("categoryColumn").append(System.getProperty("line.separator"));
        }
        return columnPostscript.toString();
    }

    public static String renderPostscriptDefinitions() {
        StringTemplate definitionsTemplate = group.getInstanceOf("categoryColumnDefinitions");
        return definitionsTemplate.toString();
    }

    public List<Column> breakIntoPostscriptColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        Column currentColumn = new Column(this.columnSize, this.categorySize);
        List<Category> sortedCategories = this.categories;
        Collections.sort(sortedCategories);
        for (Category category : sortedCategories) {
            try {
                currentColumn.addCategory(category);
            }
            catch (ColumnFullException columnFullException) {
                columns.add(currentColumn);
                currentColumn = new Column(this.columnSize, this.categorySize);
                try {
                    currentColumn.addCategory(category);
                }
                catch (ColumnFullException columnFullException2) {
                    throw new IllegalArgumentException("The column was not found to be large enough to hold even one category");
                }
            }
        }
        if (currentColumn.getCategories().size() > 0) {
            columns.add(currentColumn);
        }
        return columns;
    }

    private static class Category
    implements Comparable<Category> {
        private String name;
        private Color color;
        private List<Record> members;
        private final Color defaultColor;

        public Category(String name, Color color, Color defaultColor) {
            this(name, color, new ArrayList<Record>(), defaultColor);
        }

        public Category(String name, Color color, List<Record> members, Color defaultColor) {
            this.name = PostScriptFormationUtilities.matchParentheses(name);
            this.color = color;
            this.members = members;
            this.defaultColor = defaultColor;
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public void addMember(Record record) {
            this.members.add(record);
        }

        @Override
        public int compareTo(Category other) {
            if (this == null || other == null) {
                throw new IllegalArgumentException("You cannot compare null Categories!");
            }
            if (this == other) {
                return 0;
            }
            if (this.color == other.color) {
                return this.getName().compareTo(other.getName());
            }
            if (this.color == this.defaultColor) {
                return 1;
            }
            if (other.color == this.defaultColor) {
                return -1;
            }
            return this.getName().compareTo(other.getName());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
            result = 31 * result + (this.defaultColor == null ? 0 : this.defaultColor.hashCode());
            result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Category other = (Category)obj;
            if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
                return false;
            }
            if (this.defaultColor == null ? other.defaultColor != null : !this.defaultColor.equals(other.defaultColor)) {
                return false;
            }
            if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return "Category [name=" + this.name + ", color=" + this.color + ", #members=" + this.members.size() + "]";
        }
    }

    private static class Column {
        private List<Category> categories;
        private int columnSize;
        private final int categorySize;

        public Column(int columnSize, int categorySize) {
            this.columnSize = columnSize;
            this.categorySize = categorySize;
            this.categories = new ArrayList<Category>();
        }

        public void addCategory(Category category) throws ColumnFullException {
            if (this.columnSize >= this.categorySize) {
                this.categories.add(category);
                this.columnSize -= this.categorySize;
            } else {
                throw new ColumnFullException();
            }
        }

        public List<Category> getCategories() {
            return this.categories;
        }

        public String toString() {
            return "Column [categories=" + this.categories + ", columnSize=" + this.columnSize + ", categorySize=" + this.categorySize + "]";
        }
    }

    private static class ColumnFullException
    extends Exception {
        private static final long serialVersionUID = -6704418458099991290L;
    }
}

