/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.common;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import edu.iu.sci2.visualization.temporalbargraph.common.InvalidRecordException;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import java.util.Comparator;
import java.util.Date;
import org.cishell.utilities.NumberUtilities;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import prefuse.data.Tuple;

public class Record {
    public static final Ordering<Record> START_DATE_ORDERING = Ordering.from((Comparator)new Comparator<Record>(){

        @Override
        public int compare(Record r1, Record r2) {
            return ComparisonChain.start().compare((Comparable)r1.getStartDate(), (Comparable)r2.getStartDate()).compare((Comparable)((Object)r1.getLabel()), (Comparable)((Object)r2.getLabel())).result();
        }
    });
    public static final Ordering<Record> END_DATE_ORDERING = Ordering.from((Comparator)new Comparator<Record>(){

        @Override
        public int compare(Record r1, Record r2) {
            return ComparisonChain.start().compare((Comparable)r1.getEndDate(), (Comparable)r2.getEndDate()).compare((Comparable)((Object)r1.getLabel()), (Comparable)((Object)r2.getLabel())).result();
        }
    });
    private static final DateTimeParser[] EUROPEAN_FORMATS = new DateTimeParser[]{DateTimeFormat.fullDate().getParser(), DateTimeFormat.longDate().getParser(), DateTimeFormat.mediumDate().getParser(), DateTimeFormat.shortDate().getParser(), DateTimeFormat.forPattern((String)"d-MM-yy").getParser(), DateTimeFormat.forPattern((String)"d-MM-yyyy").getParser(), DateTimeFormat.forPattern((String)"dd-MM-yy").getParser(), DateTimeFormat.forPattern((String)"dd-MM-yyyy").getParser(), DateTimeFormat.forPattern((String)"d/MM/yy").getParser(), DateTimeFormat.forPattern((String)"dd/MM/yy").getParser(), DateTimeFormat.forPattern((String)"d/MM/yyyy").getParser(), DateTimeFormat.forPattern((String)"dd/MMM/yyyy").getParser(), DateTimeFormat.forPattern((String)"d-MMM-yy").getParser(), DateTimeFormat.forPattern((String)"d-MMM-yyyy").getParser(), DateTimeFormat.forPattern((String)"dd-MMM-yy").getParser(), DateTimeFormat.forPattern((String)"dd-MMM-yyyy").getParser(), DateTimeFormat.forPattern((String)"d/MMM/yy").getParser(), DateTimeFormat.forPattern((String)"dd/MMM/yy").getParser(), DateTimeFormat.forPattern((String)"d/MMM/yyyy").getParser(), DateTimeFormat.forPattern((String)"dd/MMM/yyyy").getParser(), DateTimeFormat.forPattern((String)"yyyy").getParser()};
    private static final DateTimeParser[] US_FORMATS = new DateTimeParser[]{DateTimeFormat.fullDate().getParser(), DateTimeFormat.fullDate().getParser(), DateTimeFormat.longDate().getParser(), DateTimeFormat.mediumDate().getParser(), DateTimeFormat.shortDate().getParser(), DateTimeFormat.forPattern((String)"MM-d-yy").getParser(), DateTimeFormat.forPattern((String)"MM-d-yyyy").getParser(), DateTimeFormat.forPattern((String)"MM-dd-yy").getParser(), DateTimeFormat.forPattern((String)"MM-dd-yyyy").getParser(), DateTimeFormat.forPattern((String)"MM/d/yy").getParser(), DateTimeFormat.forPattern((String)"MM/dd/yy").getParser(), DateTimeFormat.forPattern((String)"MM/d/yyyy").getParser(), DateTimeFormat.forPattern((String)"MMM/dd/yyyy").getParser(), DateTimeFormat.forPattern((String)"MMM-d-yy").getParser(), DateTimeFormat.forPattern((String)"MMM-d-yyyy").getParser(), DateTimeFormat.forPattern((String)"MMM-dd-yy").getParser(), DateTimeFormat.forPattern((String)"MMM-dd-yyyy").getParser(), DateTimeFormat.forPattern((String)"MMM/d/yy").getParser(), DateTimeFormat.forPattern((String)"MMM/dd/yy").getParser(), DateTimeFormat.forPattern((String)"MMM/d/yyyy").getParser(), DateTimeFormat.forPattern((String)"MMM/dd/yyyy").getParser(), DateTimeFormat.forPattern((String)"yyyy").getParser()};
    public static final Ordering<Record> AMOUNT_ORDERING = Ordering.from((Comparator)new Comparator<Record>(){

        @Override
        public int compare(Record r1, Record r2) {
            return Double.compare(r1.getAmount(), r2.getAmount());
        }
    });
    private String label;
    private DateTime startDate;
    private DateTime endDate;
    private double amount;
    private String category;

    public Record(String label, DateTime startDate, DateTime endDate, double amount, String category) {
        this.label = label;
        this.startDate = new DateTime((Object)startDate);
        this.endDate = new DateTime((Object)endDate);
        this.amount = amount;
        this.category = category;
    }

    private static DateTime getDateTimeFromObject(Object date, String dateFormat) throws InvalidRecordException {
        if (date == null) {
            throw new IllegalArgumentException("The value for the row was null");
        }
        if (date instanceof Date) {
            return new DateTime(date);
        }
        DateTimeFormatter formatter = "Month-Day-Year Date Format".equals(dateFormat) ? new DateTimeFormatterBuilder().append(null, US_FORMATS).toFormatter() : new DateTimeFormatterBuilder().append(null, EUROPEAN_FORMATS).toFormatter();
        try {
            return formatter.parseDateTime(String.valueOf(date).replaceAll("  ", " "));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRecordException("Only date objects or representations of the date that can be converted to strings are supported.  You provided an Object of '" + date.getClass().getName() + "' type." + System.getProperty("line.separator") + e.getMessage());
        }
    }

    public Record(Tuple tableRow, String labelKey, String startDateKey, String endDateKey, String sizeByKey, String startDateFormat, String endDateFormat, String categoryKey) throws InvalidRecordException {
        Object date;
        Object rawLabel = tableRow.canGetString(labelKey) ? tableRow.getString(labelKey) : tableRow.get(labelKey);
        if (rawLabel == null) {
            String exceptionMessage = "The record at row '" + tableRow.getRow() + "' did not contain a label.";
            throw new InvalidRecordException(exceptionMessage);
        }
        this.label = String.valueOf(rawLabel);
        if ("No Category Coloring".equals(categoryKey)) {
            this.category = PostScriptFormationUtilities.matchParentheses(Category.DEFAULT.toString());
        } else {
            Object rawCategoryValue = tableRow.canGetString(categoryKey) ? tableRow.getString(categoryKey) : tableRow.get(categoryKey);
            if (rawCategoryValue == null) {
                String exceptionMessage = "The record at row '" + tableRow.getRow() + "' did not contain a category.";
                throw new InvalidRecordException(exceptionMessage);
            }
            this.category = PostScriptFormationUtilities.matchParentheses(String.valueOf(rawCategoryValue));
        }
        try {
            date = tableRow.get(startDateKey);
            this.startDate = Record.getDateTimeFromObject(date, startDateFormat);
        }
        catch (IllegalArgumentException exception) {
            String exceptionMessage = "The record labeled '" + this.label + "' contains an invalid start date.";
            throw new InvalidRecordException(exceptionMessage, exception);
        }
        try {
            date = tableRow.get(endDateKey);
            this.endDate = Record.getDateTimeFromObject(date, endDateFormat);
        }
        catch (IllegalArgumentException exception) {
            String exceptionMessage = "The record labeled '" + this.label + "' contains an invalid end date.";
            throw new InvalidRecordException(exceptionMessage, exception);
        }
        try {
            Object rawAmount = tableRow.canGetDouble(sizeByKey) ? Double.valueOf(tableRow.getDouble(sizeByKey)) : tableRow.get(sizeByKey);
            if (rawAmount == null) {
                String exceptionMessage = "The record at row '" + tableRow.getRow() + "' did not contain a sizeby value.";
                throw new InvalidRecordException(exceptionMessage);
            }
            this.amount = NumberUtilities.interpretObjectAsDouble((Object)rawAmount);
            if (Double.isInfinite(this.amount) || Double.isNaN(this.amount)) {
                String exceptionMessage = "The record labeled '" + this.label + "' " + "contains an invalid value in the specified size-by " + "column (" + sizeByKey + ").";
                throw new InvalidRecordException(exceptionMessage);
            }
        }
        catch (NumberFormatException invalidNumberFormatException) {
            String exceptionMessage = "The record labeled '" + this.label + "' " + "contains an invalid number in the specified size-by column " + "(" + sizeByKey + ").";
            throw new InvalidRecordException(exceptionMessage, invalidNumberFormatException);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Record [label=").append(this.label).append(", startDate=").append(this.startDate).append(", endDate=").append(this.endDate).append(", amount=").append(this.amount).append(", category=").append(this.category).append("]");
        return builder.toString();
    }

    public static enum Category {
        DEFAULT;

    }
}

