/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.common;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.base.Preconditions;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractVisualization;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import edu.iu.sci2.visualization.temporalbargraph.common.PostScriptBar;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.utilities.color.ColorRegistry;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class Visualization
extends AbstractVisualization {
    private List<DateTime> yearMarkers;
    private DoubleDimension size;
    private double vizAreaTotalDays;
    private double vizAreaDeltaY;
    private double usableXPoints;
    private double usableYPoints;
    private double pointsPerDay;
    private double pointsPerY;
    private double barMarginTotal;
    private List<String> visualizations;
    private List<Record> records;

    public double getPointsPerY() {
        return this.pointsPerY;
    }

    public double getPointsPerDay() {
        return this.pointsPerDay;
    }

    public Visualization(CSVWriter csvWriter, List<Record> records, DoubleDimension size, boolean scaleToOnePage, ColorRegistry<String> colorRegistry) {
        Preconditions.checkNotNull((Object)csvWriter);
        Preconditions.checkNotNull(records);
        Preconditions.checkNotNull((Object)size);
        Preconditions.checkNotNull((Object)scaleToOnePage);
        Preconditions.checkNotNull(colorRegistry);
        Preconditions.checkArgument((records.size() > 0 ? 1 : 0) != 0, (Object)"You must have atleast one record to visualize!");
        Preconditions.checkArgument((Days.daysBetween((ReadableInstant)Collections.min(records, Record.START_DATE_ORDERING).getStartDate(), (ReadableInstant)Collections.max(records, Record.END_DATE_ORDERING).getEndDate()).getDays() > 1 ? 1 : 0) != 0, (Object)"You must have atleast 1 day between start and end dates to visualize!");
        this.records = records;
        this.yearMarkers = Visualization.getYearTicks(Collections.min(records, Record.START_DATE_ORDERING).getStartDate(), Collections.max(records, Record.END_DATE_ORDERING).getEndDate(), 15);
        this.size = size;
        Collections.sort(records, Record.START_DATE_ORDERING);
        List<PostScriptBar> bars = Visualization.createBars(records, csvWriter, Collections.min(this.yearMarkers), colorRegistry);
        int totalDays = Days.daysBetween((ReadableInstant)((ReadableInstant)Collections.min(this.yearMarkers)), (ReadableInstant)((ReadableInstant)Collections.max(this.yearMarkers))).getDays();
        this.vizAreaTotalDays = totalDays;
        this.barMarginTotal = this.size.getHeight() * 0.25;
        this.usableXPoints = this.size.getWidth();
        this.usableYPoints = this.size.getHeight() - this.barMarginTotal;
        this.pointsPerDay = this.usableXPoints / this.vizAreaTotalDays;
        if (scaleToOnePage) {
            this.visualizations = new ArrayList<String>();
            this.vizAreaDeltaY = Visualization.getTotalAmountPerDay(bars);
            this.pointsPerY = this.usableYPoints / this.vizAreaDeltaY;
            String page = this.getVisualizationArea(bars);
            this.visualizations.add(page);
        } else {
            double topNDeltaY;
            this.vizAreaDeltaY = topNDeltaY = Visualization.getTopNDeltaYSum(bars, 50);
            this.pointsPerY = this.usableYPoints / this.vizAreaDeltaY;
            this.visualizations = new LinkedList<String>();
            List<List<PostScriptBar>> splitBars = Visualization.splitBars(bars, 50);
            for (List<PostScriptBar> pageBars : splitBars) {
                String page = this.getVisualizationArea(pageBars);
                this.visualizations.add(page);
            }
        }
    }

    protected String getBarsArea(List<PostScriptBar> bars) {
        StringBuilder barsArea = new StringBuilder();
        double barSpacing = this.barMarginTotal / (double)(bars.size() + 2);
        double spaceUsedByBars = Visualization.getTotalAmountPerDay(bars) * this.pointsPerY;
        if (spaceUsedByBars < this.usableYPoints) {
            double extraSpace = this.usableYPoints - spaceUsedByBars;
            double extraSpacePerBar = extraSpace / (double)(bars.size() + 2);
            barSpacing += extraSpacePerBar;
        }
        StringTemplate fontTemplate = group.getInstanceOf("visualizationLabelBarFont");
        fontTemplate.setAttribute("fontname", (Object)"ArialMT");
        fontTemplate.setAttribute("fontsize", (Object)Math.min(barSpacing, 12.0));
        barsArea.append(fontTemplate.toString());
        double previousEndY = 0.0;
        for (PostScriptBar bar : bars) {
            double startY = previousEndY + barSpacing;
            double changeInY = bar.amountPerDay() * this.pointsPerY;
            StringTemplate visualizationLabelBar = group.getInstanceOf("visualizationLabelBar");
            visualizationLabelBar.setAttribute("label", (Object)bar.getName());
            visualizationLabelBar.setAttribute("x1", (Object)(bar.daysSinceEarliest() * this.pointsPerDay));
            visualizationLabelBar.setAttribute("y1", (Object)startY);
            visualizationLabelBar.setAttribute("deltaX", (Object)(bar.lengthInDays() * this.pointsPerDay));
            visualizationLabelBar.setAttribute("deltaY", (Object)changeInY);
            visualizationLabelBar.setAttribute("color", (Object)PostScriptFormationUtilities.getRGB(bar.getColor()));
            barsArea.append(visualizationLabelBar.toString());
            previousEndY = startY + changeInY;
        }
        return barsArea.toString();
    }

    protected String getDateLinesArea() {
        StringBuilder datelineArea = new StringBuilder();
        LinkedList<String> dateLines = new LinkedList<String>();
        for (DateTime newYear : this.yearMarkers) {
            String label = Integer.toString(newYear.toLocalDate().getYear());
            double x = (double)Days.daysBetween((ReadableInstant)((ReadableInstant)Collections.min(this.yearMarkers)), (ReadableInstant)newYear).getDays() * this.pointsPerDay;
            StringTemplate datelineTemplate = group.getInstanceOf("visualizationDateLine");
            datelineTemplate.setAttribute("label", (Object)label);
            datelineTemplate.setAttribute("x1", (Object)x);
            dateLines.add(datelineTemplate.toString());
        }
        for (String date : dateLines) {
            datelineArea.append(date);
        }
        return datelineArea.toString();
    }

    @Override
    protected String getVisualizationArea(List<PostScriptBar> bars) {
        StringBuilder page = new StringBuilder();
        page.append(Visualization.getSetup());
        page.append(this.getDateLinesArea());
        page.append(this.getBarsArea(bars));
        page.append(Visualization.getTearDown());
        return page.toString();
    }

    private static String getTearDown() {
        StringTemplate tearDownTemplate = group.getInstanceOf("visualizationAreaTearDown");
        return tearDownTemplate.toString();
    }

    private static String getSetup() {
        StringTemplate setupTemplate = group.getInstanceOf("visualizationAreaSetup");
        return setupTemplate.toString();
    }

    @Override
    public String renderVisualizationPostscript(int visualizationNumber) {
        return this.visualizations.get(visualizationNumber);
    }

    @Override
    public int numberOfVisualizations() {
        return this.visualizations.size();
    }

    @Override
    public String renderDefinitionsPostscript() {
        StringTemplate definitionsTemplate = group.getInstanceOf("visualizationAreaDefinitions");
        definitionsTemplate.setAttribute("topVizPosition", (Object)this.size.getHeight());
        definitionsTemplate.setAttribute("pointsPerDay", (Object)this.pointsPerDay);
        definitionsTemplate.setAttribute("pointsPerY", (Object)this.pointsPerY);
        return definitionsTemplate.toString();
    }

    @Override
    public double minRecordValue() {
        return ((Record)Record.AMOUNT_ORDERING.min(this.records)).getAmount();
    }

    @Override
    public double maxRecordValue() {
        return ((Record)Record.AMOUNT_ORDERING.max(this.records)).getAmount();
    }
}

