/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.print;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPages;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPostscriptDocument;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.print.TemporalBarGraphLandscapePages;
import edu.iu.sci2.visualization.temporalbargraph.print.TemporalBarGraphPortraitPages;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import java.util.List;
import org.cishell.utilities.color.ColorRegistry;

public class PostscriptDocument
extends AbstractPostscriptDocument {
    private DoubleDimension postscriptPageSize;
    private AbstractPages temporalBarGraphPages;

    public PostscriptDocument(CSVWriter csvWriter, List<Record> records, boolean scaleToOnePage, String areaColumn, String categoryColumn, ColorRegistry<String> colorRegistry, String labelColumn, String query, DoubleDimension pageSize) {
        this.postscriptPageSize = new DoubleDimension(PostScriptFormationUtilities.inchToPoint(pageSize.getWidth()), PostScriptFormationUtilities.inchToPoint(pageSize.getHeight()));
        this.temporalBarGraphPages = this.postscriptPageSize.getWidth() > this.postscriptPageSize.getHeight() ? new TemporalBarGraphLandscapePages(csvWriter, records, scaleToOnePage, colorRegistry, this.postscriptPageSize, areaColumn, categoryColumn, labelColumn, query) : new TemporalBarGraphPortraitPages(csvWriter, records, scaleToOnePage, colorRegistry, this.postscriptPageSize, areaColumn, categoryColumn, query);
    }

    @Override
    protected AbstractPages getPages() {
        return this.temporalBarGraphPages;
    }

    @Override
    protected DoubleDimension getPageSize() {
        return this.postscriptPageSize;
    }
}

