/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.print;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractTemporalBarGraphAlgorithm;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import edu.iu.sci2.visualization.temporalbargraph.common.PostScriptCreationException;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.common.TemporalBarGraphColorSchema;
import edu.iu.sci2.visualization.temporalbargraph.print.PostscriptDocument;
import java.awt.Color;
import java.util.Dictionary;
import java.util.List;
import org.cishell.framework.data.Data;
import org.cishell.utilities.color.ColorRegistry;
import org.cishell.utilities.color.ColorSchema;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class TemporalBarGraphAlgorithm
extends AbstractTemporalBarGraphAlgorithm {
    private Data inputData;
    private LogService logger;
    private String labelColumn;
    private String startDateColumn;
    private String endDateColumn;
    private String sizeByColumn;
    private String startDateFormat;
    private String endDateFormat;
    private double pageWidth;
    private double pageHeight;
    private boolean shouldScaleOutput;
    private String categoryColumn;
    private ColorRegistry<String> colorRegistry;
    private List<Record> records;
    private String query;

    public TemporalBarGraphAlgorithm(Data inputData, Table inputTable, LogService logger, String labelColumn, String startDateColumn, String endDateColumn, String sizeByColumn, String startDateFormat, String endDateFormat, String query, double pageWidth, double pageHeight, boolean shouldScaleOutput, String categoryColumn) {
        this.inputData = inputData;
        this.logger = logger;
        this.labelColumn = labelColumn;
        this.startDateColumn = startDateColumn;
        this.endDateColumn = endDateColumn;
        this.sizeByColumn = sizeByColumn;
        this.startDateFormat = startDateFormat;
        this.endDateFormat = endDateFormat;
        this.query = query;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.shouldScaleOutput = shouldScaleOutput;
        this.categoryColumn = categoryColumn;
        this.colorRegistry = this.categoryColumn.equals("No Category Coloring") ? new ColorRegistry((ColorSchema)new TemporalBarGraphColorSchema(new Color[]{TemporalBarGraphColorSchema.DEFAULT_COLOR}, TemporalBarGraphColorSchema.DEFAULT_COLOR), false) : new ColorRegistry(TemporalBarGraphColorSchema.DEFAULT_COLOR_SCHEMA, false);
        this.records = TemporalBarGraphAlgorithm.readRecordsFromTable(inputTable, logger, this.labelColumn, this.startDateColumn, this.endDateColumn, this.sizeByColumn, this.startDateFormat, this.endDateFormat, this.categoryColumn);
    }

    @Override
    protected String createPostScriptCode(CSVWriter csvWriter) throws PostScriptCreationException {
        PostscriptDocument postscriptDocument = new PostscriptDocument(csvWriter, this.records, this.shouldScaleOutput, this.sizeByColumn, this.categoryColumn, this.colorRegistry, this.labelColumn, this.query, new DoubleDimension(this.pageWidth, this.pageHeight));
        String documentPostScript = postscriptDocument.renderPostscript();
        return documentPostScript;
    }

    private String getSubtitle() {
        Data data = this.getInputData();
        if (data == null) {
            return "";
        }
        Dictionary metadata = data.getMetadata();
        if (metadata == null) {
            return "";
        }
        Object labelProperty = metadata.get("Label");
        if (labelProperty == null) {
            return "";
        }
        try {
            String label = (String)labelProperty;
            String subtitle = "Generated from " + label;
            return subtitle;
        }
        catch (ClassCastException classCastException) {
            return "";
        }
    }

    @Override
    protected LogService getLogger() {
        return this.logger;
    }

    @Override
    protected Data getInputData() {
        return this.inputData;
    }
}

