/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.print;

import edu.iu.sci2.visualization.temporalbargraph.common.AbstractTemporalBarGraphAlgorithmFactory;
import edu.iu.sci2.visualization.temporalbargraph.print.TemporalBarGraphAlgorithm;
import edu.iu.sci2.visualization.temporalbargraph.web.WebTemporalBarGraphAlgorithmFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Table;

public class TemporalBarGraphAlgorithmFactory
extends AbstractTemporalBarGraphAlgorithmFactory {
    public static final double PAGE_LONG_DIMENTION = 11.0;
    public static final double PAGE_SHORT_DIMENTION = 8.5;
    public static final String SUBTITLE_FIELD_ID = "subtitle";
    public static final String DEFAULT_SUBTITLE_PREFIX = "Generated from ";
    public static final String SIMPLIFIED_LAYOUT_ID = "is_simplified_layout";

    @Override
    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        boolean isSimplifiedLayout = (Boolean)parameters.get(SIMPLIFIED_LAYOUT_ID);
        if (isSimplifiedLayout) {
            Algorithm webTemporalBarGraphAlgorithm = new WebTemporalBarGraphAlgorithmFactory().createAlgorithm(data, parameters, ciShellContext);
            return webTemporalBarGraphAlgorithm;
        }
        Data inputData = data[0];
        Table inputTable = (Table)inputData.getData();
        LogService logger = (LogService)ciShellContext.getService(LogService.class.getName());
        String labelColumn = parameters.get("label").toString();
        String startDateColumn = parameters.get("start_date").toString();
        String endDateColumn = parameters.get("end_date").toString();
        String sizeByColumn = parameters.get("size_by").toString();
        String startDateFormat = (String)parameters.get("date_format");
        String endDateFormat = (String)parameters.get("date_format");
        String pageOrientation = PageOrientation.LANDSCAPE.toString();
        String categoryColumn = (String)parameters.get("category");
        String query = (String)parameters.get(SUBTITLE_FIELD_ID);
        boolean shouldScaleOutput = (Boolean)parameters.get("should_scale_output");
        PageOrientation orientation = PageOrientation.valueOf(pageOrientation);
        Double pageWidth = orientation.getWidth();
        Double pageHeight = orientation.getHeight();
        return new TemporalBarGraphAlgorithm(inputData, inputTable, logger, labelColumn, startDateColumn, endDateColumn, sizeByColumn, startDateFormat, endDateFormat, query, pageWidth, pageHeight, shouldScaleOutput, categoryColumn);
    }

    private static Collection<String> formOrientationLabels() {
        ArrayList<String> orientationLabels = new ArrayList<String>(PageOrientation.values().length);
        PageOrientation[] pageOrientationArray = PageOrientation.values();
        int n = pageOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            PageOrientation orientation = pageOrientationArray[n2];
            orientationLabels.add(orientation.getLabel());
            ++n2;
        }
        return orientationLabels;
    }

    private static Collection<String> formOrientationValues() {
        ArrayList<String> orientationValues = new ArrayList<String>(PageOrientation.values().length);
        PageOrientation[] pageOrientationArray = PageOrientation.values();
        int n = pageOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            PageOrientation orientation = pageOrientationArray[n2];
            orientationValues.add(orientation.getValue());
            ++n2;
        }
        return orientationValues;
    }

    @Override
    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        AttributeDefinition[] oldAttributeDefinitions;
        Data inputData = data[0];
        Table table = (Table)inputData.getData();
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        AttributeDefinition[] attributeDefinitionArray = oldAttributeDefinitions = oldParameters.getAttributeDefinitions(-1);
        int n = oldAttributeDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttributeDefinition = attributeDefinitionArray[n2];
            String oldAttributeDefinitionID = oldAttributeDefinition.getID();
            AttributeDefinition newAttributeDefinition = oldAttributeDefinition;
            if (oldAttributeDefinitionID.equals("label")) {
                newAttributeDefinition = MutateParameterUtilities.formLabelAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table);
            } else if (oldAttributeDefinitionID.equals("start_date") || oldAttributeDefinitionID.equals("end_date")) {
                newAttributeDefinition = MutateParameterUtilities.formDateAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table);
            } else if (oldAttributeDefinitionID.equals("size_by")) {
                newAttributeDefinition = MutateParameterUtilities.formNumberAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table);
            } else if (!oldAttributeDefinitionID.equals("page_orientation")) {
                if (oldAttributeDefinitionID.equals("date_format")) {
                    Collection<String> dateFormatLabels = TemporalBarGraphAlgorithmFactory.formDateFormatOptionLabels();
                    Collection<String> dateFormatOptions = TemporalBarGraphAlgorithmFactory.formDateFormatOptionValues();
                    newAttributeDefinition = MutateParameterUtilities.cloneToDropdownAttributeDefinition((AttributeDefinition)oldAttributeDefinition, dateFormatLabels, dateFormatOptions);
                } else if (oldAttributeDefinitionID.equals("category")) {
                    ArrayList<String> additionalOptions = new ArrayList<String>();
                    additionalOptions.add("No Category Coloring");
                    newAttributeDefinition = MutateParameterUtilities.formLabelAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table, additionalOptions);
                    MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)oldParameters, (String)"category", (String)"No Category Coloring");
                }
            }
            newParameters.addAttributeDefinition(1, newAttributeDefinition);
            ++n2;
        }
        String defaultSubtitle = DEFAULT_SUBTITLE_PREFIX + inputData.getMetadata().get("Label");
        return MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)newParameters, (String)SUBTITLE_FIELD_ID, (String)defaultSubtitle);
    }

    public static enum PageOrientation {
        LANDSCAPE(8.5, 11.0),
        PORTRAIT(11.0, 8.5);

        private final double height;
        private final double width;

        private PageOrientation(double height, double width) {
            this.height = height;
            this.width = width;
        }

        public String getLabel() {
            String label = this.toString();
            String firstLetter = label.substring(0, 1);
            String labelWithoutFirstLetter = label.toLowerCase().substring(1, label.length());
            firstLetter.toUpperCase();
            return String.valueOf(firstLetter) + labelWithoutFirstLetter;
        }

        public String getValue() {
            return this.toString();
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }
    }
}

