/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.print;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPages;
import edu.iu.sci2.visualization.temporalbargraph.common.CategoryBreakdown;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import edu.iu.sci2.visualization.temporalbargraph.common.PageElement;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.common.Visualization;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.utilities.color.ColorRegistry;
import org.freehep.graphicsio.ps.PSStringStyler;
import org.joda.time.DateTime;

public class TemporalBarGraphLandscapePages
extends AbstractPages {
    public static DecimalFormat commaFormatter = new DecimalFormat("###,###");
    public static DecimalFormat twoDecimalFormatter = new DecimalFormat("###,###.##");
    private Visualization visualizations;
    private DoubleDimension size;
    private String areaColumn;
    private String query;
    private String categoryColumn;
    private String labelColumn;
    private CategoryBreakdown categoryBreakdown;

    public TemporalBarGraphLandscapePages(CSVWriter csvWriter, List<Record> records, boolean scaleToOnePage, ColorRegistry<String> colorRegistry, DoubleDimension size, String areaColumn, String categoryColumn, String labelColumn, String query) {
        this.size = size;
        DoubleDimension visualizationSize = new DoubleDimension(size.getWidth() - PostScriptFormationUtilities.inchToPoint(3.0), size.getHeight() - size.getHeight() * 0.35);
        this.visualizations = new Visualization(csvWriter, records, visualizationSize, scaleToOnePage, colorRegistry);
        this.categoryBreakdown = new CategoryBreakdown(records, colorRegistry, 3, 400, 20);
        this.areaColumn = areaColumn;
        this.categoryColumn = categoryColumn;
        this.labelColumn = labelColumn;
        this.query = query;
    }

    @Override
    public int numberOfPages() {
        return this.visualizations.numberOfVisualizations() + this.categoryBreakdown.numberOfPages();
    }

    @Override
    public void addPageElements() {
        this.addElementsAllPages(this.getPageElementsForAllPages());
        this.addPageElementsSomePages(this.getPageElementsForSomePages());
    }

    private Map<Integer, List<PageElement>> getPageElementsForSomePages() {
        TreeMap<Integer, List<PageElement>> pageElementsSomePages = new TreeMap<Integer, List<PageElement>>();
        String visualizationDefinitions = this.visualizations.renderDefinitionsPostscript();
        int nextPage = 0;
        int ii = 0;
        while (ii < this.visualizations.numberOfVisualizations()) {
            String visualization = this.visualizations.renderVisualizationPostscript(ii);
            double visualizationLeft = PostScriptFormationUtilities.inchToPoint(0.75);
            double visualizationBottom = PostScriptFormationUtilities.inchToPoint(1.85);
            PageElement visualizationElement = new PageElement("visualization", visualizationLeft, visualizationBottom, visualization, visualizationDefinitions);
            ArrayList<PageElement> pageElements = (ArrayList<PageElement>)pageElementsSomePages.get(nextPage);
            if (!pageElementsSomePages.containsKey(nextPage)) {
                pageElements = new ArrayList<PageElement>();
            }
            pageElements.add(visualizationElement);
            pageElements.add(this.getLegendPageElement());
            pageElements.add(TemporalBarGraphLandscapePages.getHowtoPageElement());
            pageElements.add(this.getAreaLegendElement());
            pageElementsSomePages.put(nextPage, pageElements);
            ++nextPage;
            ++ii;
        }
        String categoryBreakdownDefinitions = CategoryBreakdown.renderPostscriptDefinitions();
        int ii2 = 0;
        while (ii2 < this.categoryBreakdown.numberOfPages()) {
            ArrayList<PageElement> pageElements = (ArrayList<PageElement>)pageElementsSomePages.get(nextPage);
            if (!pageElementsSomePages.containsKey(nextPage)) {
                pageElements = new ArrayList<PageElement>();
            }
            double categoryBreakdownLeft = PostScriptFormationUtilities.inchToPoint(0.5);
            double categoryBreakdownTop = 525.0;
            String categoryBreakdownPostscript = this.categoryBreakdown.renderPostscript(ii2);
            PageElement categoryBreakdownElement = new PageElement("categoryBreakdown", categoryBreakdownLeft, categoryBreakdownTop, categoryBreakdownPostscript, categoryBreakdownDefinitions);
            pageElements.add(categoryBreakdownElement);
            pageElementsSomePages.put(nextPage, pageElements);
            ++nextPage;
            ++ii2;
        }
        return pageElementsSomePages;
    }

    private List<PageElement> getPageElementsForAllPages() {
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        pageElements.add(this.getTitlePageElement());
        pageElements.add(this.getFooterPageElement());
        return pageElements;
    }

    private PageElement getAreaLegendElement() {
        double daysPerPoint = Math.pow(this.visualizations.getPointsPerDay(), -1.0);
        double yPerPoint = Math.pow(this.visualizations.getPointsPerY(), -1.0);
        double barWidth = 50.0;
        double yearValue = barWidth * daysPerPoint / 365.0;
        double bigBarHeight = 18.0;
        double bigBarValue = daysPerPoint * barWidth * (yPerPoint * bigBarHeight);
        double medBarHeight = 6.0;
        double medBarValue = daysPerPoint * barWidth * (yPerPoint * medBarHeight);
        double smallBarHeight = 2.0;
        double smallBarValue = daysPerPoint * barWidth * (yPerPoint * smallBarHeight);
        StringTemplate areaDefinitionsTemplate = pageElementsGroup.getInstanceOf("areaLegendDefinitions");
        areaDefinitionsTemplate.setAttribute("fontSize", 10);
        areaDefinitionsTemplate.setAttribute("titleFontSize", 14);
        areaDefinitionsTemplate.setAttribute("barWidth", (Object)String.valueOf(barWidth));
        areaDefinitionsTemplate.setAttribute("bigBarHeight", (Object)bigBarHeight);
        areaDefinitionsTemplate.setAttribute("medBarHeight", (Object)medBarHeight);
        areaDefinitionsTemplate.setAttribute("smallBarHeight", (Object)smallBarHeight);
        areaDefinitionsTemplate.setAttribute("bigBarValue", (Object)commaFormatter.format(bigBarValue));
        areaDefinitionsTemplate.setAttribute("medBarValue", (Object)commaFormatter.format(medBarValue));
        areaDefinitionsTemplate.setAttribute("smallBarValue", (Object)commaFormatter.format(smallBarValue));
        areaDefinitionsTemplate.setAttribute("yearValue", (Object)twoDecimalFormatter.format(yearValue));
        StringTemplate areaTemplate = pageElementsGroup.getInstanceOf("areaLegend");
        return new PageElement("areaLegend", PostScriptFormationUtilities.inchToPoint(3.6), PostScriptFormationUtilities.inchToPoint(1.5), areaTemplate, areaDefinitionsTemplate);
    }

    private PageElement getLegendPageElement() {
        String colorText2;
        String colorText1;
        StringTemplate legendTemplate = pageElementsGroup.getInstanceOf("legendTitleTop");
        if ("No Category Coloring".equals(this.categoryColumn)) {
            colorText1 = "";
            colorText2 = "";
        } else {
            colorText1 = "Color: " + this.categoryColumn;
            colorText2 = "See end of PDF for color legend.";
        }
        StringTemplate legendDefinitionsTemplate = pageElementsGroup.getInstanceOf("legendTitleTopDefinitions");
        legendDefinitionsTemplate.setAttribute("areaColumn", (Object)this.areaColumn);
        legendDefinitionsTemplate.setAttribute("minArea", (Object)commaFormatter.format(this.visualizations.minRecordValue()));
        legendDefinitionsTemplate.setAttribute("maxArea", (Object)commaFormatter.format(this.visualizations.maxRecordValue()));
        legendDefinitionsTemplate.setAttribute("labelColumn", (Object)this.labelColumn);
        legendDefinitionsTemplate.setAttribute("colorText1", (Object)colorText1);
        legendDefinitionsTemplate.setAttribute("colorText2", (Object)colorText2);
        legendDefinitionsTemplate.setAttribute("titleFontSize", 14);
        legendDefinitionsTemplate.setAttribute("normalFontSize", 10);
        double leftBound = PostScriptFormationUtilities.inchToPoint(0.25);
        double topBound = PostScriptFormationUtilities.inchToPoint(1.5);
        return new PageElement("legendTitleTop", leftBound, topBound, legendTemplate, legendDefinitionsTemplate);
    }

    private PageElement getFooterPageElement() {
        StringTemplate footerTemplate = pageElementsGroup.getInstanceOf("footer");
        footerTemplate.setAttribute("footer", (Object)"CNS (cns.iu.edu)");
        StringTemplate footerDefinitionsTemplate = pageElementsGroup.getInstanceOf("footerDefinitions");
        footerDefinitionsTemplate.setAttribute("pageWidth", (Object)this.size.getWidth());
        double leftBound = this.size.getWidth() / 2.0;
        double bottomBound = PostScriptFormationUtilities.inchToPoint(0.25);
        return new PageElement("footer", leftBound, bottomBound, footerTemplate, footerDefinitionsTemplate);
    }

    private PageElement getTitlePageElement() {
        StringTemplate titleTemplate = pageElementsGroup.getInstanceOf("pageHeading");
        StringTemplate titleDefinitionsTemplate = pageElementsGroup.getInstanceOf("pageHeadingDefinitions");
        titleDefinitionsTemplate.setAttribute("title", (Object)"Temporal Visualization");
        titleDefinitionsTemplate.setAttribute("query", (Object)PSStringStyler.getEscaped((String)this.query));
        titleDefinitionsTemplate.setAttribute("date", (Object)new DateTime().toString("MMMM dd, YYYY | h:mm a zzz"));
        double leftBound = PostScriptFormationUtilities.inchToPoint(0.25);
        double topBound = PostScriptFormationUtilities.inchToPoint(8.25);
        return new PageElement("pageHeading", leftBound, topBound, titleTemplate, titleDefinitionsTemplate);
    }

    private static PageElement getHowtoPageElement() {
        StringTemplate howtoTemplate = pageElementsGroup.getInstanceOf("howto");
        StringTemplate howtoDefinitionsTemplate = pageElementsGroup.getInstanceOf("howtoDefinitions");
        howtoDefinitionsTemplate.setAttribute("howtoTitleFontSize", 14);
        howtoDefinitionsTemplate.setAttribute("howtoTextFontSize", 10);
        double leftBound = PostScriptFormationUtilities.inchToPoint(5.85);
        double topBound = PostScriptFormationUtilities.inchToPoint(1.5);
        return new PageElement("howto", leftBound, topBound, howtoTemplate, howtoDefinitionsTemplate);
    }
}

