/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.print;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPages;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import edu.iu.sci2.visualization.temporalbargraph.common.PageElement;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.common.Visualization;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.utilities.color.ColorRegistry;
import org.freehep.graphicsio.ps.PSStringStyler;
import org.joda.time.DateTime;

public class TemporalBarGraphPortraitPages
extends AbstractPages {
    public static DecimalFormat formatter = new DecimalFormat("###,###");
    private Visualization visualizations;
    private DoubleDimension size;
    private String legendText;
    private String query;
    private String category;

    @Deprecated
    public TemporalBarGraphPortraitPages(CSVWriter csvWriter, List<Record> records, boolean scaleToOnePage, ColorRegistry<String> colorRegistry, DoubleDimension size, String legendText, String category, String query) {
        this.size = size;
        DoubleDimension visualizationSize = new DoubleDimension(this.size.getWidth() - this.size.getWidth() * 0.3, this.size.getHeight() - this.size.getHeight() * 0.25);
        this.visualizations = new Visualization(csvWriter, records, visualizationSize, scaleToOnePage, colorRegistry);
        this.legendText = legendText;
        this.category = category;
        this.query = query;
    }

    @Override
    public int numberOfPages() {
        return this.visualizations.numberOfVisualizations();
    }

    @Override
    public void addPageElements() {
        this.addElementsAllPages(this.getPageElementsForAllPages());
        this.addPageElementsSomePages(this.getPageElementsForSomePages());
    }

    private Map<Integer, List<PageElement>> getPageElementsForSomePages() {
        TreeMap<Integer, List<PageElement>> pageElementsSomePages = new TreeMap<Integer, List<PageElement>>();
        String visualizationDefinitions = this.visualizations.renderDefinitionsPostscript();
        int ii = 0;
        while (ii < this.numberOfPages()) {
            String visualization = this.visualizations.renderVisualizationPostscript(ii);
            double visualizationLeft = PostScriptFormationUtilities.inchToPoint(1.0);
            double visualizationBottom = PostScriptFormationUtilities.inchToPoint(1.75);
            PageElement visualizationElement = new PageElement("visualization", visualizationLeft, visualizationBottom, visualization, visualizationDefinitions);
            ArrayList<PageElement> pageElements = (ArrayList<PageElement>)pageElementsSomePages.get(ii);
            if (!pageElementsSomePages.containsKey(ii)) {
                pageElements = new ArrayList<PageElement>();
            }
            pageElements.add(visualizationElement);
            pageElementsSomePages.put(ii, pageElements);
            ++ii;
        }
        return pageElementsSomePages;
    }

    private List<PageElement> getPageElementsForAllPages() {
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        pageElements.add(this.getLegendPageElement());
        pageElements.add(this.getFooterPageElement());
        pageElements.add(this.getTitlePageElement());
        pageElements.add(TemporalBarGraphPortraitPages.getHowtoPageElement());
        return pageElements;
    }

    private PageElement getLegendPageElement() {
        StringTemplate legendTemplate = pageElementsGroup.getInstanceOf("legendTitleTop");
        legendTemplate.setAttribute("title", (Object)this.legendText);
        legendTemplate.setAttribute("category", (Object)this.category);
        legendTemplate.setAttribute("min", (Object)formatter.format(this.visualizations.minRecordValue()));
        legendTemplate.setAttribute("max", (Object)formatter.format(this.visualizations.maxRecordValue()));
        StringTemplate legendDefinitionsTemplate = pageElementsGroup.getInstanceOf("legendTitleTopDefinitions");
        double leftBound = PostScriptFormationUtilities.inchToPoint(1.0);
        double bottomBound = PostScriptFormationUtilities.inchToPoint(0.5);
        return new PageElement("legendTitleTop", leftBound, bottomBound, legendTemplate, legendDefinitionsTemplate);
    }

    private PageElement getFooterPageElement() {
        StringTemplate footerTemplate = pageElementsGroup.getInstanceOf("footer");
        footerTemplate.setAttribute("footer", (Object)"CNS (cns.iu.edu)");
        StringTemplate footerDefinitionsTemplate = pageElementsGroup.getInstanceOf("footerDefinitions");
        footerDefinitionsTemplate.setAttribute("pageWidth", (Object)this.size.getWidth());
        double leftBound = this.size.getWidth() / 2.0;
        double bottomBound = 0.0;
        return new PageElement("footer", leftBound, bottomBound, footerTemplate, footerDefinitionsTemplate);
    }

    private PageElement getTitlePageElement() {
        StringTemplate titleTemplate = pageElementsGroup.getInstanceOf("leftAlignedTitleWithQueryAndInfo");
        titleTemplate.setAttribute("title", (Object)"Temporal Bar Graph");
        titleTemplate.setAttribute("query", (Object)PSStringStyler.getEscaped((String)this.query));
        titleTemplate.setAttribute("date", (Object)new DateTime().toString("MMMM dd, YYYY | h:mm a zzz"));
        HashMap<String, String> attributes = new HashMap<String, String>();
        double titleFontSize = 14.0;
        String titleFontType = "Arial-BoldMT";
        Color titleFontColor = new Color(0);
        attributes.put("titleFontSize", Double.toString(titleFontSize));
        attributes.put("titleFontType", titleFontType);
        float[] titleFontRGB = titleFontColor.getRGBColorComponents(null);
        assert (titleFontRGB.length == 3);
        attributes.put("titleFontColor", String.format("%f %f %f", Float.valueOf(titleFontRGB[0]), Float.valueOf(titleFontRGB[1]), Float.valueOf(titleFontRGB[2])));
        double otherFontSize = 10.0;
        String otherFontType = "ArialMT";
        Color otherFontColor = new Color(0);
        attributes.put("otherFontSize", Double.toString(otherFontSize));
        attributes.put("otherFontType", otherFontType);
        float[] otherFontRGB = otherFontColor.getRGBColorComponents(null);
        assert (otherFontRGB.length == 3);
        attributes.put("otherFontColor", String.format("%f %f %f", Float.valueOf(otherFontRGB[0]), Float.valueOf(otherFontRGB[1]), Float.valueOf(otherFontRGB[2])));
        StringTemplate titleDefinitionsTemplate = pageElementsGroup.getInstanceOf("leftAlignedTitleWithQueryAndInfoDefinitions", attributes);
        double leftBound = PostScriptFormationUtilities.inchToPoint(1.0);
        double bottomBound = PostScriptFormationUtilities.inchToPoint(this.size.getHeight() - 1.0);
        return new PageElement("leftAlignedTitleWithQueryAndInfo", leftBound, bottomBound, titleTemplate, titleDefinitionsTemplate);
    }

    private static PageElement getHowtoPageElement() {
        StringTemplate howtoTemplate = pageElementsGroup.getInstanceOf("howto");
        StringTemplate howtoDefinitionsTemplate = pageElementsGroup.getInstanceOf("howtoDefinitions");
        howtoDefinitionsTemplate.setAttribute("howtoTitleFontSize", 10);
        howtoDefinitionsTemplate.setAttribute("howtoTextFontSize", 10);
        double leftBound = PostScriptFormationUtilities.inchToPoint(4.3);
        double bottomBound = PostScriptFormationUtilities.inchToPoint(0.4);
        return new PageElement("howto", leftBound, bottomBound, howtoTemplate, howtoDefinitionsTemplate);
    }
}

