/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.web;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPages;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPostscriptDocument;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import edu.iu.sci2.visualization.temporalbargraph.web.WebTemporalBarGraphPages;
import java.util.List;
import org.cishell.utilities.color.ColorRegistry;

public class PostscriptDocument
extends AbstractPostscriptDocument {
    private static final double WEB_HEIGHT = 960.0;
    private static final double WEB_WIDTH = 1280.0;
    private DoubleDimension size;
    private WebTemporalBarGraphPages webTemporalBarGraphPages;

    public PostscriptDocument(CSVWriter csvWriter, List<Record> records, boolean scaleToOnePage, String areaColumn, String categoryColumn, String labelColumn, ColorRegistry<String> colorRegistry) {
        double pageWidth = PostScriptFormationUtilities.inchToPoint(PostScriptFormationUtilities.pixelToInch(1280.0));
        double pageHeight = PostScriptFormationUtilities.inchToPoint(PostScriptFormationUtilities.pixelToInch(960.0));
        this.size = new DoubleDimension(pageWidth, pageHeight);
        this.webTemporalBarGraphPages = new WebTemporalBarGraphPages(csvWriter, records, scaleToOnePage, colorRegistry, this.getPageSize(), areaColumn, categoryColumn, labelColumn);
    }

    @Override
    protected AbstractPages getPages() {
        return this.webTemporalBarGraphPages;
    }

    @Override
    protected DoubleDimension getPageSize() {
        return this.size;
    }
}

