/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.web;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractTemporalBarGraphAlgorithm;
import edu.iu.sci2.visualization.temporalbargraph.common.PostScriptCreationException;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.common.TemporalBarGraphColorSchema;
import edu.iu.sci2.visualization.temporalbargraph.web.PostscriptDocument;
import java.awt.Color;
import java.util.List;
import org.cishell.framework.data.Data;
import org.cishell.utilities.color.ColorRegistry;
import org.cishell.utilities.color.ColorSchema;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class WebTemporalBarGraphAlgorithm
extends AbstractTemporalBarGraphAlgorithm {
    private LogService logger;
    private Data inputData;
    private String areaColumn;
    private boolean shouldScaleOutput;
    private ColorRegistry<String> colorRegistry;
    private List<Record> records;
    private String categoryColumn;
    private String labelColumn;

    public WebTemporalBarGraphAlgorithm(Data inputData, Table inputTable, LogService logger, String labelColumn, String startDateColumn, String endDateColumn, String sizeByColumn, String startDateFormat, String endDateFormat, boolean shouldScaleOutput, String categoryColumn) {
        this.logger = logger;
        this.inputData = inputData;
        this.labelColumn = labelColumn;
        this.areaColumn = sizeByColumn;
        this.shouldScaleOutput = shouldScaleOutput;
        this.categoryColumn = categoryColumn;
        this.colorRegistry = "No Category Coloring".equals(this.categoryColumn) ? new ColorRegistry((ColorSchema)new TemporalBarGraphColorSchema(new Color[]{TemporalBarGraphColorSchema.DEFAULT_COLOR}, TemporalBarGraphColorSchema.DEFAULT_COLOR), false) : new ColorRegistry(TemporalBarGraphColorSchema.DEFAULT_COLOR_SCHEMA, false);
        this.records = WebTemporalBarGraphAlgorithm.readRecordsFromTable(inputTable, logger, labelColumn, startDateColumn, endDateColumn, sizeByColumn, startDateFormat, endDateFormat, categoryColumn);
    }

    @Override
    protected LogService getLogger() {
        return this.logger;
    }

    @Override
    protected Data getInputData() {
        return this.inputData;
    }

    @Override
    protected String createPostScriptCode(CSVWriter csvWriter) throws PostScriptCreationException {
        PostscriptDocument postscriptDocument = new PostscriptDocument(csvWriter, this.records, this.shouldScaleOutput, this.areaColumn, this.categoryColumn, this.labelColumn, this.colorRegistry);
        return postscriptDocument.renderPostscript();
    }
}

