/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.web;

import edu.iu.sci2.visualization.temporalbargraph.common.AbstractTemporalBarGraphAlgorithmFactory;
import edu.iu.sci2.visualization.temporalbargraph.web.WebTemporalBarGraphAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;
import prefuse.data.Table;

public class WebTemporalBarGraphAlgorithmFactory
extends AbstractTemporalBarGraphAlgorithmFactory {
    @Override
    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        Data inputData = data[0];
        Table inputTable = (Table)inputData.getData();
        LogService logger = (LogService)ciShellContext.getService(LogService.class.getName());
        String labelColumn = parameters.get("label").toString();
        String startDateColumn = parameters.get("start_date").toString();
        String endDateColumn = parameters.get("end_date").toString();
        String sizeByColumn = parameters.get("size_by").toString();
        String startDateFormat = (String)parameters.get("date_format");
        String endDateFormat = (String)parameters.get("date_format");
        boolean shouldScaleOutput = (Boolean)parameters.get("should_scale_output");
        String category = (String)parameters.get("category");
        return new WebTemporalBarGraphAlgorithm(inputData, inputTable, logger, labelColumn, startDateColumn, endDateColumn, sizeByColumn, startDateFormat, endDateFormat, shouldScaleOutput, category);
    }

    @Override
    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        AttributeDefinition[] oldAttributeDefinitions;
        Data inputData = data[0];
        Table table = (Table)inputData.getData();
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        AttributeDefinition[] attributeDefinitionArray = oldAttributeDefinitions = oldParameters.getAttributeDefinitions(-1);
        int n = oldAttributeDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttributeDefinition = attributeDefinitionArray[n2];
            String oldAttributeDefinitionID = oldAttributeDefinition.getID();
            AttributeDefinition newAttributeDefinition = oldAttributeDefinition;
            if (oldAttributeDefinitionID.equals("label")) {
                newAttributeDefinition = MutateParameterUtilities.formLabelAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table);
            } else if (oldAttributeDefinitionID.equals("start_date") || oldAttributeDefinitionID.equals("end_date")) {
                newAttributeDefinition = MutateParameterUtilities.formDateAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table);
            } else if (oldAttributeDefinitionID.equals("size_by")) {
                newAttributeDefinition = MutateParameterUtilities.formNumberAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table);
            } else if (oldAttributeDefinitionID.equals("date_format")) {
                Collection<String> dateFormatLabels = WebTemporalBarGraphAlgorithmFactory.formDateFormatOptionLabels();
                Collection<String> dateFormatOptions = WebTemporalBarGraphAlgorithmFactory.formDateFormatOptionValues();
                newAttributeDefinition = MutateParameterUtilities.cloneToDropdownAttributeDefinition((AttributeDefinition)oldAttributeDefinition, dateFormatLabels, dateFormatOptions);
            } else if (oldAttributeDefinitionID.equals("category")) {
                ArrayList<String> additionalOptions = new ArrayList<String>();
                additionalOptions.add("No Category Coloring");
                newAttributeDefinition = MutateParameterUtilities.formLabelAttributeDefinition((AttributeDefinition)oldAttributeDefinition, (Table)table, additionalOptions);
                MutateParameterUtilities.mutateDefaultValue((ObjectClassDefinition)oldParameters, (String)"category", (String)"No Category Coloring");
            }
            newParameters.addAttributeDefinition(1, newAttributeDefinition);
            ++n2;
        }
        return newParameters;
    }
}

