/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.sci2.visualization.temporalbargraph.web;

import au.com.bytecode.opencsv.CSVWriter;
import edu.iu.sci2.visualization.temporalbargraph.common.AbstractPages;
import edu.iu.sci2.visualization.temporalbargraph.common.CategoryBreakdown;
import edu.iu.sci2.visualization.temporalbargraph.common.DoubleDimension;
import edu.iu.sci2.visualization.temporalbargraph.common.PageElement;
import edu.iu.sci2.visualization.temporalbargraph.common.Record;
import edu.iu.sci2.visualization.temporalbargraph.common.Visualization;
import edu.iu.sci2.visualization.temporalbargraph.utilities.PostScriptFormationUtilities;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.stringtemplate.StringTemplate;
import org.cishell.utilities.color.ColorRegistry;

public class WebTemporalBarGraphPages
extends AbstractPages {
    public static DecimalFormat formatter = new DecimalFormat("###,###");
    private Visualization visualizations;
    private DoubleDimension size;
    private String areaColumn;
    private String categoryColumn;
    private CategoryBreakdown categoryBreakdown;
    private String labelColumn;

    public WebTemporalBarGraphPages(CSVWriter csvWriter, List<Record> records, boolean scaleToOnePage, ColorRegistry<String> colorRegistry, DoubleDimension size, String areaColumn, String categoryColumn, String labelColumn) {
        this.size = size;
        this.areaColumn = areaColumn;
        this.categoryColumn = categoryColumn;
        this.labelColumn = labelColumn;
        DoubleDimension visualizationSize = new DoubleDimension(1000.0, 725.0);
        this.visualizations = new Visualization(csvWriter, records, visualizationSize, scaleToOnePage, colorRegistry);
        this.categoryBreakdown = new CategoryBreakdown(records, colorRegistry, 4, 800, 20);
    }

    private Map<Integer, List<PageElement>> getPageElementsForSomePages() {
        TreeMap<Integer, List<PageElement>> pageElementsSomePages = new TreeMap<Integer, List<PageElement>>();
        String visualizationDefinitions = this.visualizations.renderDefinitionsPostscript();
        int nextPage = 0;
        int ii = 0;
        while (ii < this.visualizations.numberOfVisualizations()) {
            String visualization = this.visualizations.renderVisualizationPostscript(ii);
            PageElement visualizationElement = new PageElement("visualization", 100.0, 200.0, visualization, visualizationDefinitions);
            ArrayList<PageElement> pageElements = (ArrayList<PageElement>)pageElementsSomePages.get(nextPage);
            if (!pageElementsSomePages.containsKey(nextPage)) {
                pageElements = new ArrayList<PageElement>();
            }
            pageElements.add(visualizationElement);
            pageElements.add(this.getLegendPageElement());
            pageElements.add(this.getAreaLegendElement());
            pageElementsSomePages.put(nextPage, pageElements);
            ++nextPage;
            ++ii;
        }
        String categoryBreakdownDefinitions = CategoryBreakdown.renderPostscriptDefinitions();
        int ii2 = 0;
        while (ii2 < this.categoryBreakdown.numberOfPages()) {
            ArrayList<PageElement> pageElements = (ArrayList<PageElement>)pageElementsSomePages.get(nextPage);
            if (!pageElementsSomePages.containsKey(nextPage)) {
                pageElements = new ArrayList<PageElement>();
            }
            double categoryBreakdownLeft = 100.0;
            double categoryBreakdownTop = 900.0;
            String categoryBreakdownPostscript = this.categoryBreakdown.renderPostscript(ii2);
            PageElement categoryBreakdownElement = new PageElement("categoryBreakdown", categoryBreakdownLeft, categoryBreakdownTop, categoryBreakdownPostscript, categoryBreakdownDefinitions);
            pageElements.add(categoryBreakdownElement);
            pageElementsSomePages.put(nextPage, pageElements);
            ++nextPage;
            ++ii2;
        }
        return pageElementsSomePages;
    }

    private List<PageElement> getPageElementsForAllPages() {
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        pageElements.add(this.getFooterPageElement());
        return pageElements;
    }

    private PageElement getAreaLegendElement() {
        double daysPerPoint = Math.pow(this.visualizations.getPointsPerDay(), -1.0);
        double yPerPoint = Math.pow(this.visualizations.getPointsPerY(), -1.0);
        double barWidth = PostScriptFormationUtilities.inchToPoint(1.7);
        double yearValue = barWidth * daysPerPoint / 365.0;
        double bigBarHeight = PostScriptFormationUtilities.inchToPoint(0.5);
        double bigBarValue = daysPerPoint * barWidth * (yPerPoint * bigBarHeight);
        double medBarHeight = PostScriptFormationUtilities.inchToPoint(0.3);
        double medBarValue = daysPerPoint * barWidth * (yPerPoint * medBarHeight);
        double smallBarHeight = PostScriptFormationUtilities.inchToPoint(0.1);
        double smallBarValue = daysPerPoint * barWidth * (yPerPoint * smallBarHeight);
        StringTemplate areaDefinitionsTemplate = pageElementsGroup.getInstanceOf("areaLegendDefinitions");
        areaDefinitionsTemplate.setAttribute("fontSize", 16);
        areaDefinitionsTemplate.setAttribute("titleFontSize", 20);
        areaDefinitionsTemplate.setAttribute("barWidth", (Object)String.valueOf(barWidth));
        areaDefinitionsTemplate.setAttribute("bigBarHeight", (Object)bigBarHeight);
        areaDefinitionsTemplate.setAttribute("medBarHeight", (Object)medBarHeight);
        areaDefinitionsTemplate.setAttribute("smallBarHeight", (Object)smallBarHeight);
        areaDefinitionsTemplate.setAttribute("bigBarValue", (Object)formatter.format(bigBarValue));
        areaDefinitionsTemplate.setAttribute("medBarValue", (Object)formatter.format(medBarValue));
        areaDefinitionsTemplate.setAttribute("smallBarValue", (Object)formatter.format(smallBarValue));
        areaDefinitionsTemplate.setAttribute("yearValue", (Object)formatter.format(yearValue));
        StringTemplate areaTemplate = pageElementsGroup.getInstanceOf("areaLegend");
        return new PageElement("areaLegend", PostScriptFormationUtilities.inchToPoint(5.56), PostScriptFormationUtilities.inchToPoint(2.1999999999999993), areaTemplate, areaDefinitionsTemplate);
    }

    private PageElement getLegendPageElement() {
        String colorText2;
        String colorText1;
        StringTemplate legendTemplate = pageElementsGroup.getInstanceOf("legendTitleTop");
        if ("No Category Coloring".equals(this.categoryColumn)) {
            colorText1 = "";
            colorText2 = "";
        } else {
            colorText1 = "Color: " + this.categoryColumn;
            colorText2 = "See end of PDF for color legend.";
        }
        StringTemplate legendDefinitionsTemplate = pageElementsGroup.getInstanceOf("legendTitleTopDefinitions");
        legendDefinitionsTemplate.setAttribute("areaColumn", (Object)this.areaColumn);
        legendDefinitionsTemplate.setAttribute("minArea", (Object)formatter.format(this.visualizations.minRecordValue()));
        legendDefinitionsTemplate.setAttribute("maxArea", (Object)formatter.format(this.visualizations.maxRecordValue()));
        legendDefinitionsTemplate.setAttribute("labelColumn", (Object)this.labelColumn);
        legendDefinitionsTemplate.setAttribute("colorText1", (Object)colorText1);
        legendDefinitionsTemplate.setAttribute("colorText2", (Object)colorText2);
        legendDefinitionsTemplate.setAttribute("titleFontSize", 20);
        legendDefinitionsTemplate.setAttribute("normalFontSize", 16);
        double leftBound = PostScriptFormationUtilities.inchToPoint(0.25);
        double topBound = PostScriptFormationUtilities.inchToPoint(2.33);
        return new PageElement("legendTitleTop", leftBound, topBound, legendTemplate, legendDefinitionsTemplate);
    }

    private PageElement getFooterPageElement() {
        StringTemplate footerTemplate = pageElementsGroup.getInstanceOf("footer");
        footerTemplate.setAttribute("footer", (Object)"CNS (cns.iu.edu)");
        StringTemplate footerDefinitionsTemplate = pageElementsGroup.getInstanceOf("footerDefinitions");
        footerDefinitionsTemplate.setAttribute("pageWidth", (Object)this.size.getWidth());
        return new PageElement("footer", 0.0, PostScriptFormationUtilities.inchToPoint(0.25), footerTemplate, footerDefinitionsTemplate);
    }

    @Override
    public int numberOfPages() {
        return this.visualizations.numberOfVisualizations() + this.categoryBreakdown.numberOfPages();
    }

    @Override
    public void addPageElements() {
        this.addElementsAllPages(this.getPageElementsForAllPages());
        this.addPageElementsSomePages(this.getPageElementsForSomePages());
    }
}

