/*
 * Decompiled with CFR 0.152.
 */
package bibtex.dom;

import bibtex.dom.BibtexAbstractEntry;
import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexMultipleValues;
import bibtex.dom.BibtexNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BibtexEntry
extends BibtexAbstractEntry {
    private String entryType;
    private String entryKey;
    private HashMap fields = new HashMap();

    BibtexEntry(BibtexFile file, String entryType, String entryKey) {
        super(file);
        this.entryKey = entryKey;
        this.entryType = entryType.toLowerCase().intern();
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public BibtexAbstractValue getFieldValue(String name) {
        return (BibtexAbstractValue)this.fields.get(name);
    }

    public List getFieldValuesAsList(String fieldName) {
        Object value = this.fields.get(fieldName);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof BibtexMultipleValues) {
            return ((BibtexMultipleValues)value).getValues();
        }
        return Collections.singletonList(value);
    }

    public void addFieldValue(String fieldName, BibtexAbstractValue value) {
        BibtexAbstractValue currentValue = this.getFieldValue(fieldName);
        if (currentValue == null) {
            this.setField(fieldName, value);
        } else if (currentValue instanceof BibtexMultipleValues) {
            BibtexMultipleValues multipleValues = (BibtexMultipleValues)currentValue;
            multipleValues.addValue(value);
        } else {
            BibtexMultipleValues multipleValues = this.getOwnerFile().makeBibtexMultipleValues();
            multipleValues.addValue(currentValue);
            multipleValues.addValue(value);
            this.setField(fieldName, multipleValues);
        }
    }

    public String getEntryType() {
        return this.entryType;
    }

    public Map getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void setField(String fieldName, BibtexAbstractValue fieldValue) {
        this.fields.put(fieldName.toLowerCase().intern(), fieldValue);
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey.toLowerCase();
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType.toLowerCase().intern();
    }

    @Override
    public void printBibtex(PrintWriter writer) {
        writer.print('@');
        writer.print(this.entryType);
        writer.print('{');
        writer.print(this.entryKey);
        writer.println(',');
        Object[] keys = new String[this.fields.keySet().size()];
        this.fields.keySet().toArray(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            BibtexNode value = (BibtexNode)this.fields.get(key);
            if (value instanceof BibtexMultipleValues) {
                BibtexMultipleValues values = (BibtexMultipleValues)value;
                for (BibtexNode element : values.getValues()) {
                    writer.print('\t');
                    writer.print((String)key);
                    writer.print('=');
                    element.printBibtex(writer);
                    writer.println(',');
                }
            } else {
                writer.print('\t');
                writer.print((String)key);
                writer.print('=');
                value.printBibtex(writer);
                writer.println(',');
            }
            ++i;
        }
        writer.println('}');
    }

    public void undefineField(String fieldName) {
        this.fields.remove(fieldName);
    }
}

