/*
 * Decompiled with CFR 0.152.
 */
package bibtex.dom;

import bibtex.dom.BibtexAbstractEntry;
import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexConcatenatedValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexMacroDefinition;
import bibtex.dom.BibtexMacroReference;
import bibtex.dom.BibtexMultipleValues;
import bibtex.dom.BibtexNode;
import bibtex.dom.BibtexPerson;
import bibtex.dom.BibtexPersonList;
import bibtex.dom.BibtexPreamble;
import bibtex.dom.BibtexString;
import bibtex.dom.BibtexToplevelComment;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BibtexFile
extends BibtexNode {
    private final ArrayList entries = new ArrayList();

    public BibtexFile() {
        super(null);
    }

    public void addEntry(BibtexAbstractEntry entry) {
        this.entries.add(entry);
    }

    public void removeEntry(BibtexAbstractEntry entry) {
        this.entries.remove(entry);
    }

    public List getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public BibtexConcatenatedValue makeConcatenatedValue(BibtexAbstractValue left, BibtexAbstractValue right) {
        return new BibtexConcatenatedValue(this, left, right);
    }

    public BibtexEntry makeEntry(String entryType, String entryKey) {
        return new BibtexEntry(this, entryType, entryKey == null ? "" : entryKey);
    }

    public BibtexPersonList makePersonList() {
        return new BibtexPersonList(this);
    }

    public BibtexPerson makePerson(String first, String preLast, String last, String lineage, boolean isOthers) {
        return new BibtexPerson(this, first, preLast, last, lineage, isOthers);
    }

    public BibtexPreamble makePreamble(BibtexAbstractValue content) {
        return new BibtexPreamble(this, content);
    }

    public BibtexString makeString(String content) {
        return new BibtexString(this, content);
    }

    public BibtexMultipleValues makeBibtexMultipleValues() {
        return new BibtexMultipleValues(this);
    }

    public BibtexMacroDefinition makeMacroDefinition(String key, BibtexAbstractValue value) {
        return new BibtexMacroDefinition(this, key, value);
    }

    public BibtexMacroReference makeMacroReference(String key) {
        return new BibtexMacroReference(this, key);
    }

    public BibtexToplevelComment makeToplevelComment(String content) {
        return new BibtexToplevelComment(this, content);
    }

    @Override
    public void printBibtex(PrintWriter writer) {
        for (BibtexNode node : this.entries) {
            node.printBibtex(writer);
        }
        writer.flush();
    }
}

