/*
 * Decompiled with CFR 0.152.
 */
package bibtex.dom;

import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexNode;
import java.io.PrintWriter;

public final class BibtexPerson
extends BibtexNode {
    private String first;
    private String preLast;
    private String last;
    private String lineage;
    private boolean isOthers;

    BibtexPerson(BibtexFile file, String first, String preLast, String last, String lineage, boolean isOthers) {
        super(file);
        this.first = first;
        this.preLast = preLast;
        this.last = last;
        this.lineage = lineage;
        this.isOthers = isOthers;
    }

    public String getFirst() {
        return this.first;
    }

    public boolean isOthers() {
        return this.isOthers;
    }

    public String getLast() {
        return this.last;
    }

    public String getLineage() {
        return this.lineage;
    }

    public String getPreLast() {
        return this.preLast;
    }

    public void setFirst(String first) {
        this.first = first;
    }

    public void setOthers(boolean isAndOthers) {
        this.isOthers = isAndOthers;
    }

    public void setLast(String last) {
        this.last = last;
    }

    public void setLineage(String lineage) {
        this.lineage = lineage;
    }

    public void setPreLast(String preLast) {
        this.preLast = preLast;
    }

    @Override
    public void printBibtex(PrintWriter writer) {
        if (this.isOthers) {
            writer.print("others");
        } else {
            if (this.preLast != null) {
                writer.print(this.preLast);
                writer.print(' ');
            }
            if (this.last != null) {
                writer.print(this.last);
            }
            if (this.lineage != null || this.first != null) {
                writer.print(", ");
            }
            if (this.lineage != null) {
                writer.print(this.lineage);
                writer.print(", ");
            }
            if (this.first != null) {
                writer.print(this.first);
            } else if (this.lineage != null) {
                writer.print("{}");
            }
        }
    }
}

