/*
 * Decompiled with CFR 0.152.
 */
package bibtex.parser;

import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexFile;
import bibtex.parser.ParseException;
import bibtex.parser.PseudoLexer;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;

public final class BibtexParser {
    private PseudoLexer lexer;
    private BibtexFile bibtexFile;
    private LinkedList exceptions;
    private boolean throwAllParseExceptions;
    private int multipleFieldValuesPolicy = 0;
    private static final char[] EXCEPTION_SET_NAMES = new char[]{'\"', '#', '%', '\'', '(', ')', ',', '=', '{', '}'};
    private static final String[] ENTRY_TYPES = new String[]{"string", "preamble", "article", "book", "booklet", "conference", "inbook", "incollection", "inproceedings", "manual", "mastersthesis", "misc", "phdthesis", "proceedings", "techreport", "unpublished", "periodical"};

    public BibtexParser(boolean throwAllParseExceptions) {
        this.throwAllParseExceptions = throwAllParseExceptions;
    }

    public ParseException[] getExceptions() {
        if (this.exceptions == null) {
            return new ParseException[0];
        }
        ParseException[] result = new ParseException[this.exceptions.size()];
        this.exceptions.toArray(result);
        return result;
    }

    public void parse(BibtexFile bibtexFile, Reader input) throws ParseException, IOException {
        this.lexer = new PseudoLexer(input);
        this.bibtexFile = bibtexFile;
        this.exceptions = new LinkedList();
        block7: while (true) {
            PseudoLexer.Token token = this.lexer.scanTopLevelCommentOrAtOrEOF();
            switch (token.choice) {
                case 0: {
                    bibtexFile.addEntry(bibtexFile.makeToplevelComment(token.content));
                    continue block7;
                }
                case 1: {
                    if (this.throwAllParseExceptions) {
                        this.parseEntry();
                        continue block7;
                    }
                    try {
                        this.parseEntry();
                    }
                    catch (ParseException parseException) {
                        this.exceptions.add(parseException);
                    }
                    continue block7;
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private void parseEntry() throws ParseException, IOException {
        String entryType = this.lexer.scanEntryTypeName().toLowerCase();
        int bracketChoice = this.lexer.scanAlternatives(new char[]{'{', '('}, false);
        if (entryType.equals("string")) {
            String stringName = this.lexer.scanLiteral(EXCEPTION_SET_NAMES, true, true);
            this.lexer.scan('=');
            BibtexAbstractValue value = this.parseValue();
            this.bibtexFile.addEntry(this.bibtexFile.makeMacroDefinition(stringName, value));
        } else if (entryType.equals("preamble")) {
            BibtexAbstractValue value = this.parseValue();
            this.bibtexFile.addEntry(this.bibtexFile.makePreamble(value));
        } else {
            String bibkey;
            this.lexer.skipNonNewlineWhitespaceAndLatexComments();
            String string = bibkey = this.lexer.currentInputChar() == ',' || this.lexer.currentInputChar() == '\n' ? "" : this.lexer.scanLiteral(new char[]{',', '\n'}, true, true);
            if (bibkey.equals("")) {
                bibkey = "";
                this.lexer.setCurrentForCheatingPurposes(',');
            }
            BibtexEntry entry = this.bibtexFile.makeEntry(entryType, bibkey);
            this.bibtexFile.addEntry(entry);
            while (true) {
                this.lexer.enforceNoEof("',' or corresponding closing bracket", true);
                if (this.lexer.currentInputChar() != ',') break;
                this.lexer.scan(',');
                this.lexer.enforceNoEof("'}' or [FIELDNAME]", true);
                if (this.lexer.currentInputChar() == '}') break;
                String fieldName = this.lexer.scanLiteral(EXCEPTION_SET_NAMES, true, true);
                this.lexer.scan('=');
                BibtexAbstractValue value = this.parseValue();
                switch (this.multipleFieldValuesPolicy) {
                    case 0: {
                        if (entry.getFieldValue(fieldName) != null) break;
                        entry.setField(fieldName, value);
                        break;
                    }
                    case 1: {
                        entry.setField(fieldName, value);
                        break;
                    }
                    case 2: {
                        entry.addFieldValue(fieldName, value);
                    }
                }
            }
        }
        if (bracketChoice == 0) {
            this.lexer.scan('}');
        } else {
            this.lexer.scan(')');
        }
    }

    private static boolean isNumber(String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c < '0' || '9' < c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private BibtexAbstractValue parseValue() throws ParseException, IOException {
        String stringContent;
        this.lexer.enforceNoEof("[STRING] or [STRINGREFERENCE] or [NUMBER]", true);
        char inputCharacter = this.lexer.currentInputChar();
        BibtexAbstractValue result = inputCharacter == '\"' ? this.parseQuotedString() : (inputCharacter == '{' ? this.parseBracketedString() : (BibtexParser.isNumber(stringContent = this.lexer.scanLiteral(EXCEPTION_SET_NAMES, false, true).trim()) ? this.bibtexFile.makeString(stringContent) : this.bibtexFile.makeMacroReference(stringContent)));
        this.lexer.enforceNoEof("'#' or something else", true);
        if (this.lexer.currentInputChar() == '#') {
            this.lexer.scan('#');
            return this.bibtexFile.makeConcatenatedValue(result, this.parseValue());
        }
        return result;
    }

    private BibtexAbstractValue parseBracketedString() throws ParseException, IOException {
        StringBuffer buffer = new StringBuffer();
        this.lexer.scanBracketedString(buffer, false);
        return this.bibtexFile.makeString(buffer.toString());
    }

    private BibtexAbstractValue parseQuotedString() throws IOException, ParseException {
        return this.bibtexFile.makeString(this.lexer.scanQuotedString());
    }

    public void setMultipleFieldValuesPolicy(int multipleFieldValuesPolicy) {
        this.multipleFieldValuesPolicy = multipleFieldValuesPolicy;
    }
}

