/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import java.io.IOException;
import java.util.ArrayList;

public class CSVParser {
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private String pending;
    private final boolean ignoreLeadingWhiteSpace;
    public static final int INITIAL_READ_SIZE = 128;
    public static final boolean DEFAULT_STRICT_QUOTES = false;
    public static final boolean DEFAULT_IGNORE_LEADING_WHITESPACE = true;

    public CSVParser() {
        this(',', '\"', '\u0000');
    }

    public CSVParser(char separator) {
        this(separator, '\"', '\u0000');
    }

    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\u0000');
    }

    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, true);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        if (separator == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public String[] parseLineMulti(String nextLine) throws IOException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLine(String nextLine) throws IOException {
        return this.parseLine(nextLine, false);
    }

    /*
     * Unable to fully structure code
     */
    private String[] parseLine(String nextLine, boolean multi) throws IOException {
        inField = false;
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                s = this.pending;
                this.pending = null;
                return new String[]{s};
            }
            return null;
        }
        tokensOnThisLine = new ArrayList<String>();
        sb = new StringBuilder(128);
        inQuotes = false;
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = true;
        }
        i = 0;
        while (i < nextLine.length()) {
            block16: {
                block17: {
                    block18: {
                        block15: {
                            c = nextLine.charAt(i);
                            if (this.escape == '\u0000' || c != this.escape) break block15;
                            if (this.isNextCharacterEscapable(nextLine, inQuotes != false || inField != false, i)) {
                                sb.append(nextLine.charAt(i + 1));
                                ++i;
                            }
                            break block16;
                        }
                        if (c != this.quotechar) break block17;
                        if (!this.isNextCharacterEscapedQuote(nextLine, inQuotes, i)) break block18;
                        sb.append(nextLine.charAt(i + 1));
                        ++i;
                        break block16;
                    }
                    if (this.strictQuotes || i <= 0 || nextLine.charAt(i - 1) == this.separator || this.isNextCharacterCloseQuote(nextLine, inQuotes != false || inField != false, i)) ** GOTO lbl41
                    if (!this.ignoreLeadingWhiteSpace || sb.length() <= 0 || !this.isAllWhiteSpace(sb)) {
                        sb.append(c);
                    } else {
                        sb.setLength(0);
lbl41:
                        // 2 sources

                        inQuotes = inQuotes == false;
                        inField = inField == false;
                    }
                    break block16;
                }
                if (c == this.separator && !inQuotes) {
                    tokensOnThisLine.add(sb.toString());
                    sb.setLength(0);
                    inField = false;
                } else if (!this.strictQuotes || inQuotes) {
                    sb.append(c);
                    inField = true;
                }
            }
            ++i;
        }
        if (inQuotes) {
            if (multi) {
                sb.append("\n");
                this.pending = sb.toString();
                sb = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of CSV line");
            }
        }
        if (sb != null) {
            tokensOnThisLine.add(sb.toString());
        }
        return tokensOnThisLine.toArray(new String[tokensOnThisLine.size()]);
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > ++i && nextLine.charAt(i) == this.quotechar;
    }

    private boolean isNextCharacterCloseQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && (nextLine.length() <= ++i || nextLine.charAt(i) == this.separator || nextLine.charAt(i) == '\n');
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && (nextLine.charAt(i + 1) == this.quotechar || nextLine.charAt(i + 1) == this.escape);
    }

    protected boolean isAllWhiteSpace(CharSequence sb) {
        boolean result = true;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++i;
        }
        return result;
    }
}

