/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVWriteProc;
import au.com.bytecode.opencsv.ResultSetHelper;
import au.com.bytecode.opencsv.ResultSetHelperService;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class CSVWriter
implements Closeable {
    public static final int INITIAL_STRING_SIZE = 128;
    private Writer rawWriter;
    private PrintWriter pw;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    private ResultSetHelper resultService = new ResultSetHelperService();

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\u0000');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, "\n");
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\u0000', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.rawWriter = writer;
        this.pw = new PrintWriter(writer);
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeAll(List<String[]> allLines) {
        for (String[] line : allLines) {
            this.writeNext(line);
        }
    }

    protected void writeColumnNames(ResultSet rs) throws SQLException {
        this.writeNext(this.resultService.getColumnNames(rs));
    }

    public void writeAll(ResultSet rs, boolean includeColumnNames) throws SQLException, IOException {
        if (includeColumnNames) {
            this.writeColumnNames(rs);
        }
        while (rs.next()) {
            this.writeNext(this.resultService.getColumnValues(rs));
        }
    }

    public void writeNext(String ... nextLine) {
        if (nextLine == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (i < nextLine.length) {
            String nextElement;
            if (i != 0) {
                sb.append(this.separator);
            }
            if ((nextElement = nextLine[i]) != null) {
                if (this.quotechar != '\u0000') {
                    sb.append(this.quotechar);
                }
                sb.append(this.stringContainsSpecialCharacters(nextElement) ? this.processLine(nextElement) : nextElement);
                if (this.quotechar != '\u0000') {
                    sb.append(this.quotechar);
                }
            }
            ++i;
        }
        sb.append(this.lineEnd);
        this.pw.write(sb.toString());
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(this.quotechar) != -1 || line.indexOf(this.escapechar) != -1;
    }

    protected StringBuilder processLine(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        int j = 0;
        while (j < nextElement.length()) {
            char nextChar = nextElement.charAt(j);
            if (nextChar == this.quotechar) {
                sb.append(this.quotechar).append(this.quotechar);
            } else if (this.escapechar != '\u0000' && nextChar == this.escapechar) {
                sb.append(this.escapechar).append(this.escapechar);
            } else {
                sb.append(nextChar);
            }
            ++j;
        }
        return sb;
    }

    public void flush() throws IOException {
        this.pw.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.pw.close();
        this.rawWriter.close();
    }

    public boolean checkError() {
        return this.pw.checkError();
    }

    public void setResultService(ResultSetHelper resultService) {
        this.resultService = resultService;
    }

    public void write(CSVWriteProc proc) {
        proc.process(this);
    }
}

