/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.algorithm.convertergraph;

import edu.uci.ics.jung.graph.Graph;
import java.util.Dictionary;
import org.cishell.algorithm.convertergraph.ConverterGraphComputation;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ConverterGraphAlgorithm
implements Algorithm {
    private LogService logger;
    private BundleContext bundleContext;
    private Graph outputGraph;
    private int nodeCount = 0;
    private int edgeCount = 0;

    public ConverterGraphAlgorithm(Data[] data, Dictionary parameters, CIShellContext ciShellContext, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.logger = (LogService)ciShellContext.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        ServiceReference[] allConverterServices = this.getAllConverters();
        ConverterGraphComputation converterGraphComputation = new ConverterGraphComputation(allConverterServices, this.logger);
        return this.prepareOutputMetadata((Data)new BasicData((Object)converterGraphComputation.getOutputGraph(), Graph.class.getName()));
    }

    private ServiceReference[] getAllConverters() {
        try {
            ServiceReference[] allConverters = this.bundleContext.getAllServiceReferences(AlgorithmFactory.class.getName(), "(&(type=converter))");
            if (allConverters == null) {
                allConverters = new ServiceReference[]{};
            }
            return allConverters;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return new ServiceReference[0];
        }
    }

    private Data[] prepareOutputMetadata(Data outNWBData) {
        outNWBData.getMetadata().put("Label", "Converter Graph having " + ((Graph)outNWBData.getData()).numVertices() + " nodes & " + ((Graph)outNWBData.getData()).numEdges() + " edges.");
        outNWBData.getMetadata().put("Type", "Network");
        return new Data[]{outNWBData};
    }
}

