/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.algorithm.convertergraph;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseVertex;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class ConverterGraphComputation {
    private LogService logger;
    private ServiceReference[] allConverterServices;
    private Set nodeLabels = new HashSet();
    private Graph outputGraph;
    private int nodeCount = 0;

    public Graph getOutputGraph() {
        return this.outputGraph;
    }

    public ConverterGraphComputation(ServiceReference[] allConverterServices, LogService logger) {
        this.logger = logger;
        this.allConverterServices = allConverterServices;
        this.outputGraph = new DirectedSparseGraph();
        this.processServiceReferences();
    }

    private void processServiceReferences() {
        int converterCount = 0;
        while (converterCount < this.allConverterServices.length) {
            ServiceReference currentConverterServiceReference = this.allConverterServices[converterCount];
            String sourceNodeKey = (String)currentConverterServiceReference.getProperty("in_data");
            String targetNodeKey = (String)currentConverterServiceReference.getProperty("out_data");
            Vertex sourceNode = this.nodeLabels.contains(sourceNodeKey) ? this.updateNode(sourceNodeKey) : this.createNode(sourceNodeKey);
            Vertex targetNode = this.nodeLabels.contains(targetNodeKey) ? this.updateNode(targetNodeKey) : this.createNode(targetNodeKey);
            this.createEdge(sourceNode, targetNode, currentConverterServiceReference);
            ++converterCount;
        }
    }

    private Vertex updateNode(String currentNodeKey) {
        for (Vertex currentVertex : this.outputGraph.getVertices()) {
            if (!currentVertex.getUserDatum((Object)"label").toString().equalsIgnoreCase(currentNodeKey)) continue;
            int currentVertexStrength = (Integer)currentVertex.getUserDatum((Object)"strength");
            currentVertex.setUserDatum((Object)"strength", (Object)new Integer(++currentVertexStrength), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
            return currentVertex;
        }
        return new DirectedSparseVertex();
    }

    private Vertex createNode(String nodeKey) {
        ++this.nodeCount;
        DirectedSparseVertex node = new DirectedSparseVertex();
        node.addUserDatum((Object)"strength", (Object)new Integer(1), (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        node.addUserDatum((Object)"label", (Object)nodeKey, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        this.outputGraph.addVertex((Vertex)node);
        this.nodeLabels.add(nodeKey);
        return node;
    }

    private void createEdge(Vertex sourceNode, Vertex targetNode, ServiceReference currentConverterServiceReference) {
        String serviceCompletePID = (String)currentConverterServiceReference.getProperty("service.pid");
        int startIndexForConverterName = serviceCompletePID.lastIndexOf(".") + 1;
        String serviceShortPID = serviceCompletePID.substring(startIndexForConverterName);
        DirectedSparseEdge edge = new DirectedSparseEdge(sourceNode, targetNode);
        edge.addUserDatum((Object)"converter_name", (Object)serviceShortPID, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        edge.addUserDatum((Object)"service_pid", (Object)serviceCompletePID, (UserDataContainer.CopyAction)new UserDataContainer.CopyAction.Shared());
        this.outputGraph.addEdge((Edge)edge);
    }
}

