/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.app.service.filesaver;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import org.cishell.app.service.filesaver.FileSaveException;
import org.cishell.app.service.filesaver.FileSaveListener;
import org.cishell.app.service.filesaver.FileSaverService;
import org.cishell.framework.data.Data;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;

public abstract class AbstractFileSaverService
implements FileSaverService {
    public static final Collection<Character> INVALID_FILENAME_CHARACTERS = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(new Character('\\'), new Character('/'), new Character(':'), new Character('*'), new Character('?'), new Character('\"'), new Character('<'), new Character('>'), new Character('|'), new Character('%'))));
    public static final char FILENAME_CHARACTER_REPLACEMENT = '#';
    public static final String FILE_EXTENSION_PREFIX = "file-ext:";
    public static final String FILE_PREFIX = "file:";
    private Collection<FileSaveListener> listeners;

    @Override
    public void registerListener(FileSaveListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(FileSaveListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public File promptForTargetFile() throws FileSaveException {
        return this.promptForTargetFile("");
    }

    @Override
    public File promptForTargetFile(String defaultFileExtension) throws FileSaveException {
        return this.promptForTargetFile("", defaultFileExtension);
    }

    @Override
    public File promptForTargetFile(Data datum, String defaultFileExtension) throws FileSaveException {
        Object dataObject = datum.getData();
        if (dataObject instanceof File) {
            String fileName = ((File)datum.getData()).getName();
            return this.promptForTargetFile(fileName, defaultFileExtension);
        }
        return this.promptForTargetFile(this.suggestFileName(datum), defaultFileExtension);
    }

    @Override
    public File promptForTargetFile(File outputFile) throws FileSaveException {
        return this.promptForTargetFile(outputFile.getName(), "");
    }

    @Override
    public File saveData(Data sourceDatum) throws FileSaveException {
        return this.saveData(sourceDatum, "file-ext:*");
    }

    @Override
    public File saveData(Data sourceDatum, String targetMimeType) throws FileSaveException {
        Converter converter = this.promptForConverter(sourceDatum, targetMimeType);
        if (converter != null) {
            return this.saveData(sourceDatum, converter);
        }
        return null;
    }

    @Override
    public File saveData(Data sourceDatum, Converter converter) throws FileSaveException {
        String outputMimeType = converter.getProperties().get("out_data").toString();
        System.err.println("outputMimeType: " + outputMimeType);
        String suggestedFileExtension = AbstractFileSaverService.suggestFileExtension(outputMimeType);
        System.err.println("suggestedFileExtension: " + suggestedFileExtension);
        File targetFile = this.promptForTargetFile(sourceDatum, suggestedFileExtension);
        if (targetFile != null) {
            return this.saveData(sourceDatum, converter, targetFile);
        }
        return null;
    }

    @Override
    public File saveData(Data sourceDatum, Converter converter, File targetFile) throws FileSaveException {
        try {
            Data convertedDatum = converter.convert(sourceDatum);
            this.saveTo((File)convertedDatum.getData(), targetFile);
            return targetFile;
        }
        catch (ConversionException e) {
            throw new FileSaveException(e.getMessage(), e);
        }
    }

    @Override
    public File save(File sourceFile) throws FileSaveException {
        File targetFile = this.promptForTargetFile(sourceFile);
        this.saveTo(sourceFile, targetFile);
        return targetFile;
    }

    @Override
    public String suggestFileName(Data datum) {
        return AbstractFileSaverService.replaceInvalidFilenameCharacters(AbstractFileSaverService.getLabel(datum));
    }

    private static String getLabel(Data datum) {
        Dictionary<String, Object> metadata = datum.getMetadata();
        Object labelObject = metadata.get("Label");
        if (labelObject != null) {
            return labelObject.toString();
        }
        Object shortLabelObject = metadata.get("Short_Label");
        if (shortLabelObject != null) {
            return shortLabelObject.toString();
        }
        return datum.toString();
    }

    private static String replaceInvalidFilenameCharacters(String fileName) {
        String cleanedFilename = fileName;
        for (Character invalidCharacter : INVALID_FILENAME_CHARACTERS) {
            cleanedFilename = cleanedFilename.replace(invalidCharacter.charValue(), '#');
        }
        return cleanedFilename;
    }

    private static String suggestFileExtension(String targetMimeType) {
        if (targetMimeType.startsWith(FILE_EXTENSION_PREFIX)) {
            return targetMimeType.substring(FILE_EXTENSION_PREFIX.length());
        }
        if (targetMimeType.startsWith(FILE_PREFIX)) {
            int forwardSlashCharacterIndex = targetMimeType.indexOf(47);
            if (forwardSlashCharacterIndex != -1) {
                int parsedOutFileExtensionStart = forwardSlashCharacterIndex + 1;
                if (parsedOutFileExtensionStart < targetMimeType.length()) {
                    return targetMimeType.substring(parsedOutFileExtensionStart);
                }
                return "";
            }
            return "";
        }
        return targetMimeType;
    }
}

