/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.datamanager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cishell.app.service.datamanager.DataManagerListener;
import org.cishell.app.service.datamanager.DataManagerService;
import org.cishell.app.service.fileloader.FileLoaderService;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.CIShellContextDelegate;
import org.cishell.framework.LocalCIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.datamanager.Activator;
import org.cishell.reference.gui.datamanager.CIShellDataTransfer;
import org.cishell.reference.gui.datamanager.DataGUIItem;
import org.cishell.reference.gui.datamanager.DataTreeContentProvider;
import org.cishell.reference.gui.datamanager.DataTreeLabelProvider;
import org.cishell.reference.gui.workspace.CIShellApplication;
import org.cishell.utilities.StringUtilities;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public abstract class AbstractDataManagerView
extends ViewPart
implements BundleListener,
DataManagerListener {
    private String brandPluginID;
    private DataManagerService manager;
    private TreeViewer viewer;
    private TreeEditor editor;
    private Text newEditor;
    private DataGUIItem rootItem;
    private boolean updatingTreeItem;
    private Tree tree;
    private Menu menu;
    private Map<Data, DataGUIItem> dataToDataGUIItem;
    private AlgorithmFactory saveFactory;
    private AlgorithmFactory viewFactory;
    private AlgorithmFactory viewWithFactory;
    private DiscardListener discardListener;
    private SaveListener saveListener;
    private ViewListener viewListener;
    private ViewWithListener viewWithListener;
    private LogService logger;

    public AbstractDataManagerView(String brandPluginID) {
        this.brandPluginID = brandPluginID;
        this.dataToDataGUIItem = new HashMap<Data, DataGUIItem>();
        this.manager = Activator.getDataManagerService();
        this.logger = Activator.getLogService();
        if (this.manager == null && this.logger != null) {
            this.logger.log(1, "Data Manager Service unavailable!");
        }
    }

    private String getItemID(ServiceReference serviceReference) {
        return serviceReference.getProperty("PID:service.pid") + "-SID:" + serviceReference.getProperty("service.id");
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new DataTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DataTreeLabelProvider());
        this.rootItem = new DataGUIItem(null, null, this.brandPluginID);
        this.viewer.setInput((Object)this.rootItem);
        this.viewer.expandAll();
        this.tree = this.viewer.getTree();
        this.tree.addSelectionListener((SelectionListener)new DatamodelSelectionListener());
        this.tree.addMouseListener((MouseListener)new ContextMenuListener());
        this.menu = new Menu((Control)this.tree);
        this.menu.setVisible(false);
        MenuItem saveItem = new MenuItem(this.menu, 8);
        saveItem.setText("Save");
        this.saveListener = new SaveListener();
        saveItem.addListener(13, (Listener)this.saveListener);
        MenuItem viewItem = new MenuItem(this.menu, 8);
        viewItem.setText("View");
        this.viewListener = new ViewListener();
        viewItem.addListener(13, (Listener)this.viewListener);
        MenuItem viewWithItem = new MenuItem(this.menu, 8);
        viewWithItem.setText("View With...");
        this.viewWithListener = new ViewWithListener();
        viewWithItem.addListener(13, (Listener)this.viewWithListener);
        MenuItem renameItem = new MenuItem(this.menu, 8);
        renameItem.setText("Rename");
        renameItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractDataManagerView.this.handleInput();
            }
        });
        MenuItem discardItem = new MenuItem(this.menu, 8);
        discardItem.setText("Discard");
        this.discardListener = new DiscardListener();
        discardItem.addListener(13, (Listener)this.discardListener);
        this.tree.setMenu(this.menu);
        this.editor = new TreeEditor(this.tree);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        if (this.manager != null) {
            this.manager.addDataManagerListener((DataManagerListener)this);
        } else {
            Activator.getBundleContext().addBundleListener((BundleListener)this);
            this.manager = Activator.getDataManagerService();
            if (this.manager != null) {
                this.manager.addDataManagerListener((DataManagerListener)this);
            }
        }
        this.getSite().setSelectionProvider((ISelectionProvider)new DataModelSelectionProvider());
        this.setupDataManagerViewForDragAndDrop(parent);
    }

    private void setupDataManagerViewForDragAndDrop(Composite parent) {
        this.setupDataManagerViewForDragAndDropInto(parent);
        this.setupDataManagerViewForDragAndDropOutOf(parent);
    }

    private void setupDataManagerViewForDragAndDropInto(Composite parent) {
        DropTarget dropTarget = new DropTarget((Control)parent.getParent(), 18);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileNames = null;
                FileTransfer fileTransfer = FileTransfer.getInstance();
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    fileNames = (String[])event.data;
                    Collection flattenedFileStructure = AbstractDataManagerView.this.flattenDraggedFileStructures(fileNames);
                    ServiceReference fileLoaderServiceReference = Activator.context.getServiceReference(FileLoaderService.class.getName());
                    FileLoaderService fileLoader = (FileLoaderService)Activator.context.getService(fileLoaderServiceReference);
                    DataManagerService dataManager = (DataManagerService)Activator.context.getService(Activator.context.getServiceReference(DataManagerService.class.getName()));
                    ServiceReference dataManagerServiceReference = Activator.context.getServiceReference(DataManagerService.class.getName());
                    for (File file : flattenedFileStructure) {
                        ServiceReference uniqueServiceReference = dataManagerServiceReference;
                        CIShellContextDelegate ciShellContext = new CIShellContextDelegate(uniqueServiceReference, (CIShellContext)new LocalCIShellContext(Activator.context));
                        LogService uniqueLogger = (LogService)ciShellContext.getService(LogService.class.getName());
                        try {
                            Data[] inputData;
                            Data[] dataArray = inputData = fileLoader.loadFile(Activator.context, (CIShellContext)ciShellContext, uniqueLogger, ProgressMonitor.NULL_MONITOR, file);
                            int n = inputData.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Data inputDatum = dataArray[n2];
                                inputDatum.getMetadata().put("ServiceReference", uniqueServiceReference);
                                dataManager.addData(inputDatum);
                                ++n2;
                            }
                        }
                        catch (Throwable e) {
                            String format = "An error occurred when loading your files.%nPlease include the following when reporting this:%n%s";
                            String logMessage = String.format(format, StringUtilities.getStackTraceAsString((Throwable)e));
                            uniqueLogger.log(1, logMessage);
                        }
                    }
                }
            }
        });
    }

    private void setupDataManagerViewForDragAndDropOutOf(Composite parent) {
        Transfer[] types = new Transfer[]{new CIShellDataTransfer(Activator.context)};
        DragSource dragSource = new DragSource((Control)parent, 18);
        dragSource.setTransfer(types);
        dragSource.addDragListener(new DragSourceListener(){
            private Data[] selectedData;

            public void dragStart(DragSourceEvent event) {
                System.err.println("dragStart");
                Data[] selectedData = AbstractDataManagerView.this.manager.getSelectedData();
                if (selectedData != null && selectedData.length != 0) {
                    event.doit = true;
                    this.selectedData = selectedData;
                }
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
    }

    private Collection<File> flattenDraggedFileStructures(String[] fileNames) {
        ArrayList<File> flattenedFileStructure = new ArrayList<File>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            flattenedFileStructure.addAll(this.flattenDraggedFileStructure(fileName));
            ++n2;
        }
        return flattenedFileStructure;
    }

    private Collection<File> flattenDraggedFileStructure(String fileName) {
        File file = new File(fileName);
        if (file.isFile()) {
            ArrayList<File> flattenedFileStructure = new ArrayList<File>();
            flattenedFileStructure.add(file);
            return flattenedFileStructure;
        }
        if (file.isDirectory()) {
            ArrayList<File> flattenedFileStructure = new ArrayList<File>();
            String[] stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String childFileName = stringArray[n2];
                String completeChildFileName = String.format("%s%s%s", fileName, File.separator, childFileName);
                flattenedFileStructure.addAll(this.flattenDraggedFileStructure(completeChildFileName));
                ++n2;
            }
            return flattenedFileStructure;
        }
        return new ArrayList<File>();
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 2) {
            this.manager = Activator.getDataManagerService();
            if (this.manager != null) {
                this.manager.addDataManagerListener((DataManagerListener)this);
            }
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dataAdded(final Data newData, String label) {
        DataGUIItem parentItem = this.getParent(newData);
        final DataGUIItem newItem = new DataGUIItem(newData, parentItem, this.brandPluginID);
        parentItem.addChild(newItem);
        this.dataToDataGUIItem.put(newData, newItem);
        final HashSet<Data> selection = new HashSet<Data>();
        selection.add(newData);
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                if (!AbstractDataManagerView.this.tree.isDisposed()) {
                    AbstractDataManagerView.this.viewer.refresh();
                    AbstractDataManagerView.this.updateContextMenu(newData);
                    AbstractDataManagerView.this.viewer.expandToLevel((Object)newItem, 0);
                    AbstractDataManagerView.this.manager.setSelectedData(selection.toArray(new Data[0]));
                }
            }
        });
    }

    private DataGUIItem getParent(Data data) {
        DataGUIItem parentItem;
        Dictionary modelDictionary = data.getMetadata();
        Data parent = (Data)modelDictionary.get("Parent");
        if (parent == null) {
            parentItem = this.rootItem;
        } else {
            parentItem = this.dataToDataGUIItem.get(parent);
            if (parentItem == null) {
                parentItem = this.rootItem;
            }
        }
        return parentItem;
    }

    private void guiRun(Runnable run) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            run.run();
        } else {
            Display.getDefault().syncExec(run);
        }
    }

    public void dataLabelChanged(Data data, String label) {
        if (data != null && label != null) {
            TreeItem[] treeItems = this.tree.getItems();
            int i = 0;
            while (i < treeItems.length) {
                if (((DataGUIItem)treeItems[i].getData()).getModel() == data) {
                    this.updateText(label, treeItems[i]);
                    break;
                }
                ++i;
            }
        }
    }

    public void dataRemoved(Data data) {
        TreeItem[] treeItems = this.tree.getItems();
        int i = 0;
        while (i < treeItems.length) {
            if (((DataGUIItem)treeItems[i].getData()).getModel() == data) {
                this.tree.clear(this.tree.indexOf(treeItems[i]), false);
            }
            ++i;
        }
    }

    public void dataSelected(final Data[] data) {
        if (data != null) {
            this.guiRun(new Runnable(){

                @Override
                public void run() {
                    HashSet<TreeItem> itemSet = new HashSet<TreeItem>();
                    int i = 0;
                    while (i < data.length) {
                        TreeItem[] treeItems = AbstractDataManagerView.this.tree.getItems();
                        int j = 0;
                        while (j < treeItems.length) {
                            if (treeItems[j].getData() == data[i]) {
                                itemSet.add(treeItems[j]);
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    AbstractDataManagerView.this.tree.setSelection(itemSet.toArray(new TreeItem[0]));
                    AbstractDataManagerView.this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object[])data));
                }
            });
        }
    }

    private void updateContextMenu(Data model) {
        this.saveFactory = this.enableMenuItemCheck(this.saveFactory, "org.cishell.reference.gui.persistence.save.Save", model, 0);
        this.viewFactory = this.enableMenuItemCheck(this.viewFactory, "org.cishell.reference.gui.persistence.view.FileView", model, 1);
        this.viewWithFactory = this.enableMenuItemCheck(this.viewWithFactory, "org.cishell.reference.gui.persistence.viewwith.FileViewWith", model, 2);
    }

    private AlgorithmFactory enableMenuItemCheck(AlgorithmFactory algorithmFactory, String service, Data model, int menuIndex) {
        Algorithm algorithm;
        boolean validSaveFactory = false;
        if (algorithmFactory == null) {
            algorithmFactory = Activator.getService(service);
            if (algorithmFactory != null) {
                validSaveFactory = true;
            }
        } else {
            validSaveFactory = true;
        }
        boolean enabled = false;
        if (validSaveFactory && (algorithm = algorithmFactory.createAlgorithm(new Data[]{model}, new Hashtable(), Activator.getCIShellContext())) != null) {
            enabled = true;
        }
        this.menu.getItem(menuIndex).setEnabled(enabled);
        return algorithmFactory;
    }

    private void handleInput() {
        TreeItem[] selection;
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if ((selection = this.tree.getSelection()).length != 1) {
            return;
        }
        final TreeItem item = selection[0];
        if (item == null) {
            return;
        }
        this.newEditor = new Text((Composite)this.tree, 0);
        this.newEditor.setText(item.getText());
        this.newEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!AbstractDataManagerView.this.updatingTreeItem) {
                    AbstractDataManagerView.this.manager.setLabel(((DataGUIItem)item.getData()).getModel(), AbstractDataManagerView.this.newEditor.getText());
                }
            }
        });
        this.newEditor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' && !AbstractDataManagerView.this.updatingTreeItem) {
                    AbstractDataManagerView.this.updateText(AbstractDataManagerView.this.newEditor.getText(), item);
                } else if (e.keyCode == 27) {
                    AbstractDataManagerView.this.newEditor.dispose();
                }
            }
        });
        this.newEditor.selectAll();
        this.newEditor.setFocus();
        this.editor.setEditor((Control)this.newEditor, item);
    }

    private void updateText(String newLabel, TreeItem item) {
        this.updatingTreeItem = true;
        if (newLabel.startsWith(">")) {
            newLabel = newLabel.substring(1);
        }
        this.editor.getItem().setText(newLabel);
        DataGUIItem treeItem = (DataGUIItem)item.getData();
        Data model = treeItem.getModel();
        model.getMetadata().put("Label", newLabel);
        this.viewer.refresh();
        this.newEditor.dispose();
        this.updatingTreeItem = false;
    }

    private class ContextMenuListener
    extends MouseAdapter {
        private ContextMenuListener() {
        }

        public void mouseUp(MouseEvent event) {
            if (event.button == 3) {
                TreeItem item = AbstractDataManagerView.this.tree.getItem(new Point(event.x, event.y));
                if (item != null) {
                    AbstractDataManagerView.this.tree.getMenu().setVisible(true);
                } else {
                    AbstractDataManagerView.this.tree.getMenu().setVisible(false);
                }
            }
        }
    }

    private class DataModelSelectionProvider
    implements ISelectionProvider {
        private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
        private ISelection selection;

        private DataModelSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        private TreeItem getTreeItem(Data model, TreeItem[] items) {
            TreeItem result = null;
            int i = 0;
            while (i < items.length && result == null) {
                Data item;
                DataGUIItem data = (DataGUIItem)items[i].getData();
                result = data != null ? ((item = data.getModel()) == model ? items[i] : this.getTreeItem(model, items[i].getItems())) : this.getTreeItem(model, items[i].getItems());
                ++i;
            }
            return result;
        }

        public void setSelection(ISelection selection) {
            if (selection != this.selection) {
                this.selection = selection;
                AbstractDataManagerView.this.viewer.refresh(true);
                if (selection != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection selections = (IStructuredSelection)selection;
                    Iterator iterator = selections.iterator();
                    TreeItem[] newTreeSelection = new TreeItem[selections.size()];
                    int i = 0;
                    while (iterator.hasNext()) {
                        Object next = iterator.next();
                        if (next instanceof Data) {
                            TreeItem result;
                            newTreeSelection[i] = result = this.getTreeItem((Data)next, AbstractDataManagerView.this.tree.getItems());
                            AbstractDataManagerView.this.viewer.expandToLevel(AbstractDataManagerView.this.dataToDataGUIItem.get(next), 0);
                        }
                        ++i;
                    }
                    AbstractDataManagerView.this.tree.setSelection(newTreeSelection);
                }
                for (ISelectionChangedListener listener : this.listeners) {
                    SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
                    listener.selectionChanged(event);
                }
            }
        }
    }

    private class DatamodelSelectionListener
    extends SelectionAdapter {
        private DatamodelSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Tree tree = (Tree)e.getSource();
            TreeItem[] selection = tree.getSelection();
            HashSet<Data> models = new HashSet<Data>();
            Data[] modelArray = new Data[selection.length];
            int i = 0;
            while (i < selection.length) {
                Data model = ((DataGUIItem)selection[i].getData()).getModel();
                AbstractDataManagerView.this.updateContextMenu(model);
                models.add(model);
                modelArray[i] = model;
                ++i;
            }
            AbstractDataManagerView.this.manager.setSelectedData(modelArray);
        }
    }

    private class DiscardListener
    implements Listener {
        private DiscardListener() {
        }

        public void handleEvent(Event event) {
            TreeItem[] selections;
            TreeItem[] treeItemArray = selections = AbstractDataManagerView.this.tree.getSelection();
            int n = selections.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem selection = treeItemArray[n2];
                DataGUIItem item = (DataGUIItem)selection.getData();
                DataGUIItem parent = item.getParent();
                if (parent != null) {
                    parent.removeChild(item);
                }
                AbstractDataManagerView.this.dataToDataGUIItem.remove(item.getModel());
                AbstractDataManagerView.this.manager.removeData(item.getModel());
                ++n2;
            }
            AbstractDataManagerView.this.manager.setSelectedData(new Data[0]);
            AbstractDataManagerView.this.viewer.refresh();
        }
    }

    private class SaveListener
    implements Listener {
        private SaveListener() {
        }

        public void handleEvent(Event event) {
            block4: {
                if (AbstractDataManagerView.this.saveFactory != null) {
                    Data[] data = AbstractDataManagerView.this.manager.getSelectedData();
                    Algorithm algorithm = AbstractDataManagerView.this.saveFactory.createAlgorithm(data, new Hashtable(), Activator.getCIShellContext());
                    try {
                        algorithm.execute();
                    }
                    catch (AlgorithmExecutionException e) {
                        if (AbstractDataManagerView.this.logger != null) {
                            AbstractDataManagerView.this.logger.log(1, e.getMessage(), (Throwable)e);
                            e.printStackTrace();
                        }
                        AbstractDataManagerView.this.logger = Activator.getLogService();
                        if (AbstractDataManagerView.this.logger == null) break block4;
                        AbstractDataManagerView.this.logger.log(1, "org.cishell.framework.algorithm.AlgorithmExecutionException", (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private class ViewListener
    implements Listener {
        private ViewListener() {
        }

        public void handleEvent(Event event) {
            if (AbstractDataManagerView.this.viewFactory != null) {
                Data[] data = AbstractDataManagerView.this.manager.getSelectedData();
                Algorithm algorithm = AbstractDataManagerView.this.viewFactory.createAlgorithm(data, new Hashtable(), Activator.getCIShellContext());
                try {
                    algorithm.execute();
                }
                catch (AlgorithmExecutionException e) {
                    if (AbstractDataManagerView.this.logger != null) {
                        AbstractDataManagerView.this.logger.log(1, e.getMessage(), (Throwable)e);
                    } else {
                        AbstractDataManagerView.this.logger = Activator.getLogService();
                        if (AbstractDataManagerView.this.logger != null) {
                            AbstractDataManagerView.this.logger.log(1, e.getMessage(), (Throwable)e);
                        }
                    }
                    e.printStackTrace();
                }
            }
        }
    }

    private class ViewWithListener
    implements Listener {
        private ViewWithListener() {
        }

        public void handleEvent(Event event) {
            IMenuManager topLevelMenu = CIShellApplication.getMenuManager();
            IMenuManager fileMenu = topLevelMenu.findMenuUsingPath("File");
            BundleContext bundleContext = Activator.getBundleContext();
            try {
                ServiceReference[] serviceReference = bundleContext.getAllServiceReferences(AlgorithmFactory.class.getName(), "(service.pid=org.cishell.reference.gui.persistence.viewwith.FileViewWith)");
                if (serviceReference != null && serviceReference.length > 0) {
                    ActionContributionItem action = (ActionContributionItem)fileMenu.find(AbstractDataManagerView.this.getItemID(serviceReference[0]));
                    action.getAction().run();
                }
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

