/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.datamanager;

import java.io.File;
import org.cishell.app.service.filesaver.FileSaveException;
import org.cishell.app.service.filesaver.FileSaverService;
import org.cishell.framework.data.Data;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CIShellDataTransfer
extends ByteArrayTransfer {
    public static final String TYPE_NAME = "CIShellData";
    public static final int TYPE_ID = CIShellDataTransfer.registerType((String)"CIShellData");
    private BundleContext bundleContext;

    public CIShellDataTransfer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void javaToNative(Object object, TransferData transferData) {
        System.err.println(String.format("javaToNative: %s (%s) %s", object, object.getClass().getName(), transferData));
        if (object == null || !(object instanceof Data[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            Data[] data = (Data[])object;
            Data[] convertedData = this.convertData(data);
            String[] convertedFilePaths = this.formConvertedFilePaths(convertedData);
            FileTransfer.getInstance().javaToNative((Object)convertedFilePaths, transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        return null;
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    private Data[] convertData(Data[] data) {
        Data[] convertedData = new Data[data.length];
        int ii = 0;
        while (ii < data.length) {
            try {
                convertedData[ii] = this.convertDatum(data[ii]);
            }
            catch (Throwable throwable) {}
            ++ii;
        }
        return convertedData;
    }

    private Data convertDatum(Data datum) throws ConversionException, FileSaveException {
        ServiceReference fileSaverServiceReference = this.bundleContext.getServiceReference(FileSaverService.class.getName());
        FileSaverService fileSaver = (FileSaverService)this.bundleContext.getService(fileSaverServiceReference);
        Converter converter = fileSaver.promptForConverter(datum, "file-ext:*");
        return converter.convert(datum);
    }

    private String[] formConvertedFilePaths(Data[] convertedData) {
        String[] convertedFilePaths = new String[convertedData.length];
        int ii = 0;
        while (ii < convertedData.length) {
            convertedFilePaths[ii] = ((File)convertedData[ii].getData()).getAbsolutePath();
            ++ii;
        }
        return convertedFilePaths;
    }
}

