/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.datamanager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cishell.framework.data.Data;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DataGUIItem {
    private String brandPluginID;
    private Image treeIcon;
    private Image networkIcon;
    private Image unknownIcon;
    private Image textIcon;
    private Image plotIcon;
    private Image tableIcon;
    private Image databaseIcon;
    private Image rasterImageIcon;
    private Image vectorImageIcon;
    private Image modelIcon;
    private Image rIcon;
    private Map<String, Image> typeToImage = new HashMap<String, Image>();
    private Collection<DataGUIItem> children = new ArrayList<DataGUIItem>();
    private Data data;
    private DataGUIItem parent;
    private static final String DEFAULT_IMAGE_LOCATION = String.valueOf(File.separator) + "unknown.png";

    public DataGUIItem(Data data, DataGUIItem parent, String brandPluginID) {
        this.data = data;
        this.parent = parent;
        this.brandPluginID = brandPluginID;
        this.treeIcon = DataGUIItem.getImage("tree.png", this.brandPluginID);
        this.networkIcon = DataGUIItem.getImage("network.png", this.brandPluginID);
        this.unknownIcon = DataGUIItem.getImage("unknown.png", this.brandPluginID);
        this.textIcon = DataGUIItem.getImage("text.png", this.brandPluginID);
        this.plotIcon = DataGUIItem.getImage("plot.png", this.brandPluginID);
        this.tableIcon = DataGUIItem.getImage("table.png", this.brandPluginID);
        this.databaseIcon = DataGUIItem.getImage("database.jpg", this.brandPluginID);
        this.rasterImageIcon = DataGUIItem.getImage("raster_image.jpg", this.brandPluginID);
        this.vectorImageIcon = DataGUIItem.getImage("vector_image.jpg", this.brandPluginID);
        this.modelIcon = DataGUIItem.getImage("model.jpg", this.brandPluginID);
        this.rIcon = DataGUIItem.getImage("r.png", this.brandPluginID);
        this.registerImage("Unknown", this.unknownIcon);
        this.registerImage("Matrix", this.tableIcon);
        this.registerImage("Network", this.networkIcon);
        this.registerImage("Tree", this.treeIcon);
        this.registerImage("Text", this.textIcon);
        this.registerImage("Plot", this.plotIcon);
        this.registerImage("Table", this.tableIcon);
        this.registerImage("Database", this.databaseIcon);
        this.registerImage("Raster Image", this.rasterImageIcon);
        this.registerImage("Vector Image", this.vectorImageIcon);
        this.registerImage("Model", this.modelIcon);
        this.registerImage("R Instance", this.rIcon);
    }

    public Data getModel() {
        return this.data;
    }

    public DataGUIItem getParent() {
        return this.parent;
    }

    public void addChild(DataGUIItem item) {
        this.children.add(item);
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public void removeChild(DataGUIItem item) {
        this.children.remove(item);
    }

    public Image getIcon() {
        Image icon = this.typeToImage.get(this.data.getMetadata().get("Type"));
        if (icon == null) {
            icon = this.unknownIcon;
        }
        return icon;
    }

    public void registerImage(String type, Image image) {
        this.typeToImage.put(type, image);
    }

    public static Image getImage(String name, String brandPluginID) {
        if (Platform.isRunning()) {
            String imageLocation = String.format("%sicons%s%s", File.separator, File.separator, name);
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)brandPluginID, (String)imageLocation);
            if (imageDescriptor != null) {
                return imageDescriptor.createImage();
            }
            String errorMessage = String.format("Could not find the icon '%s' in '%s'. Using the default image instead.", imageLocation, brandPluginID);
            System.err.println(errorMessage);
            return DataGUIItem.getDefaultImage();
        }
        String format = "Could not obtain the image '%s' in '%s', since the platform was not running (?). Using the default image instead.";
        String errorMessage = String.format(format, name, brandPluginID);
        System.err.println(errorMessage);
        return DataGUIItem.getDefaultImage();
    }

    private static Image getDefaultImage() {
        String thisPluginID = "org.cishell.reference.gui.datamanager";
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)thisPluginID, (String)DEFAULT_IMAGE_LOCATION);
        return imageDescriptor.createImage();
    }
}

