/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt;

import java.util.Dictionary;
import org.cishell.reference.gui.guibuilder.swt.SWTGuiComposite;
import org.cishell.reference.gui.guibuilder.swt.builder.GUIComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.UpdateListener;
import org.cishell.service.guibuilder.GUI;
import org.cishell.service.guibuilder.SelectionListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class SWTGui
implements GUI,
UpdateListener {
    private static final int MAXIMUM_INITIAL_DIALOGUE_HEIGHT = 500;
    public static final int TEXT_WRAP_LENGTH = 350;
    private Shell shell;
    private SWTGuiComposite composite;
    private SelectionListener listener;
    private boolean hitOk = false;
    private Button okButton;

    public SWTGui(Shell shell, int style, String id, MetaTypeProvider provider) {
        this.shell = shell;
        if (provider == null) {
            throw new IllegalArgumentException("Null MetaTypeProvider given");
        }
        ObjectClassDefinition ocd = provider.getObjectClassDefinition(id, null);
        this.shell.setText(ocd.getName());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.shell.setLayout((Layout)gridLayout);
        Font defaultFont = new Font((Device)this.shell.getDisplay(), "SanSerif", 8, 0);
        String message = ocd.getDescription();
        if (message != null && !message.equals("")) {
            Label msg = new Label((Composite)this.shell, 64);
            msg.setText(message);
            msg.pack(true);
            GridData labelData = new GridData();
            labelData.horizontalAlignment = 2;
            labelData.grabExcessHorizontalSpace = true;
            if (msg.getSize().x > 350) {
                labelData.widthHint = 350;
            }
            msg.setLayoutData((Object)labelData);
        }
        this.composite = new SWTGuiComposite((Composite)this.shell, style, id, provider);
        this.composite.addUpdateListener(this);
        Composite buttonsGroup = new Composite((Composite)this.shell, 0);
        FillLayout rowLayout = new FillLayout();
        rowLayout.spacing = 5;
        buttonsGroup.setLayout((Layout)rowLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.grabExcessHorizontalSpace = false;
        buttonsGroup.setLayoutData((Object)gridData);
        this.okButton = new Button(buttonsGroup, 8);
        this.okButton.setText("OK");
        this.okButton.setSize(40, 20);
        this.okButton.setFont(defaultFont);
        this.okButton.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTGui.this.hitOk = true;
                SWTGui.this.close();
                if (SWTGui.this.listener != null) {
                    SWTGui.this.listener.hitOk(SWTGui.this.composite.getEnteredResponses());
                }
            }
        });
        Button cancel = new Button(buttonsGroup, 0);
        cancel.setText("Cancel");
        cancel.setSize(40, 20);
        cancel.setFont(defaultFont);
        cancel.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTGui.this.close();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!SWTGui.this.hitOk && SWTGui.this.listener != null) {
                    SWTGui.this.listener.cancelled();
                }
            }
        });
        this.shell.setDefaultButton(this.okButton);
        this.validate();
    }

    public void close() {
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SWTGui.this.shell.close();
                SWTGui.this.shell.dispose();
            }
        });
    }

    public boolean isClosed() {
        return this.shell.isDisposed();
    }

    public void open() {
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SWTGui.this.shell.pack();
                this.resizeShell(SWTGui.this.shell);
                SWTGui.this.shell.open();
            }

            private void resizeShell(Shell shell) {
                Point shellSize = shell.getSize();
                shell.setSize(shellSize.x, this.calculateNewDialogHeight(shellSize.y));
            }

            private int calculateNewDialogHeight(int proposedHeight) {
                return Math.min(500, proposedHeight);
            }
        });
    }

    public Dictionary<String, Object> openAndWait() {
        this.open();
        final Display display = this.shell.getDisplay();
        OpenAndWaitListener listener = new OpenAndWaitListener();
        this.setSelectionListener(listener);
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                while (!SWTGui.this.isClosed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        return listener.valuesEntered;
    }

    public void setSelectionListener(SelectionListener listener) {
        this.listener = listener;
    }

    public String validate() {
        String valid = this.composite.validate();
        if (valid != null && valid.length() > 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
        return valid;
    }

    @Override
    public void componentUpdated(GUIComponent component) {
        this.validate();
    }

    private static class OpenAndWaitListener
    implements SelectionListener {
        Dictionary<String, Object> valuesEntered = null;

        private OpenAndWaitListener() {
        }

        public void cancelled() {
        }

        public void hitOk(Dictionary<String, Object> valuesEntered) {
            this.valuesEntered = valuesEntered;
        }
    }
}

