/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.cishell.reference.gui.guibuilder.swt.SWTGui;
import org.cishell.reference.gui.guibuilder.swt.builder.AbstractDialog;
import org.cishell.service.guibuilder.GUI;
import org.cishell.service.guibuilder.GUIBuilderService;
import org.cishell.service.guibuilder.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.metatype.MetaTypeProvider;

public class SWTGuiBuilderService
implements GUIBuilderService {
    private static final GUI NULL_GUI = new GUI(){

        public void open() {
        }

        public void close() {
        }

        public boolean isClosed() {
            return true;
        }

        public Dictionary openAndWait() {
            return new Hashtable();
        }

        public void setSelectionListener(SelectionListener listener) {
            if (listener != null) {
                listener.cancelled();
            }
        }
    };
    private Display display;
    private Shell lastShell;

    public SWTGuiBuilderService(Display display) {
        this.display = display;
    }

    public GUI createGUI(String id, MetaTypeProvider parameters) {
        boolean validParams = true;
        try {
            validParams = parameters.getObjectClassDefinition(id, null) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            validParams = false;
        }
        if (validParams) {
            GUICreator creator = new GUICreator(id, parameters);
            this.display.syncExec((Runnable)creator);
            return creator.gui;
        }
        return NULL_GUI;
    }

    private Shell getActiveShell() {
        final Returner returner = new Returner();
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                returner.returnValue = SWTGuiBuilderService.this.display.getActiveShell();
                if (returner.returnValue == null) {
                    returner.returnValue = SWTGuiBuilderService.this.lastShell != null ? SWTGuiBuilderService.this.lastShell : new Shell();
                }
            }
        });
        this.lastShell = (Shell)returner.returnValue;
        return (Shell)returner.returnValue;
    }

    private void guiRun(Runnable runner) {
        if (this.display.getThread() == Thread.currentThread()) {
            runner.run();
        } else {
            this.display.syncExec(runner);
        }
    }

    public Dictionary createGUIandWait(String id, MetaTypeProvider parameters) {
        return this.createGUI(id, parameters).openAndWait();
    }

    public boolean showConfirm(final String title, final String message, final String detail) {
        final Returner returner = new Returner();
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                returner.returnValue = new Boolean(AbstractDialog.openConfirm(SWTGuiBuilderService.this.getActiveShell(), title, message, detail));
            }
        });
        return (Boolean)returner.returnValue;
    }

    public void showError(final String title, final String message, final String detail) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                AbstractDialog.openError(SWTGuiBuilderService.this.getActiveShell(), title, message, detail);
            }
        });
    }

    public void showError(String title, String message, Throwable error) {
        if (error != null) {
            StringWriter writer = new StringWriter();
            error.printStackTrace(new PrintWriter(writer));
            this.showError(title, message, writer.getBuffer().toString());
        }
    }

    public void showInformation(final String title, final String message, final String detail) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                AbstractDialog.openInformation(SWTGuiBuilderService.this.getActiveShell(), title, message, detail);
            }
        });
    }

    public boolean showQuestion(final String title, final String message, final String detail) {
        final Returner returner = new Returner();
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                returner.returnValue = new Boolean(AbstractDialog.openQuestion(SWTGuiBuilderService.this.getActiveShell(), title, message, detail));
            }
        });
        return (Boolean)returner.returnValue;
    }

    public void showWarning(final String title, final String message, final String detail) {
        this.guiRun(new Runnable(){

            @Override
            public void run() {
                AbstractDialog.openWarning(SWTGuiBuilderService.this.getActiveShell(), title, message, detail);
            }
        });
    }

    static /* synthetic */ GUI access$0() {
        return NULL_GUI;
    }

    private class GUICreator
    implements Runnable {
        GUI gui = SWTGuiBuilderService.access$0();
        String id;
        MetaTypeProvider parameters;

        public GUICreator(String id, MetaTypeProvider parameters) {
            this.id = id;
            this.parameters = parameters;
        }

        @Override
        public void run() {
            try {
                Shell activeShell = SWTGuiBuilderService.this.getActiveShell();
                Shell shell = new Shell(activeShell, 2160);
                if (activeShell != null) {
                    shell.setImage(activeShell.getImage());
                }
                this.gui = new SWTGui(shell, 0, this.id, this.parameters);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private static class Returner {
        Object returnValue;

        private Returner() {
        }
    }
}

