/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cishell.reference.gui.guibuilder.swt.builder.ComponentProvider;
import org.cishell.reference.gui.guibuilder.swt.builder.GUIComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.UpdateListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class SWTGuiComposite
implements UpdateListener {
    private ObjectClassDefinition objectClassDefinition;
    private Dictionary<String, GUIComponent> idToComponentMap;
    private Dictionary<String, Object> enteredResponses;
    protected Set<UpdateListener> updateListeners;
    private Composite parent;
    private Composite parameterArea;
    private ScrolledComposite scrollingArea;

    public SWTGuiComposite(Composite parent, int style, String id, MetaTypeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null MetaTypeProvider given");
        }
        this.idToComponentMap = new Hashtable<String, GUIComponent>();
        this.objectClassDefinition = provider.getObjectClassDefinition(id, null);
        this.parent = parent;
        this.updateListeners = new HashSet<UpdateListener>();
        this.enteredResponses = new Hashtable<String, Object>();
        this.setupGUI();
        AttributeDefinition[] attributeDefinitionArray = this.objectClassDefinition.getAttributeDefinitions(-1);
        int n = attributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition attribute = attributeDefinitionArray[n2];
            GUIComponent component = ComponentProvider.getInstance().createComponent(attribute);
            component.setAttributeDefinition(attribute);
            component.createGUI(this.parameterArea, style);
            this.idToComponentMap.put(attribute.getID(), component);
            component.addUpdateListener(this);
            Object value = component.getValue();
            String valid = component.validate();
            if (value != null && (valid == null || valid.length() == 0)) {
                this.enteredResponses.put(component.getAttributeDefinition().getID(), value);
            }
            ++n2;
        }
        this.setScrollDimensions(this.scrollingArea, this.parameterArea);
        this.parameterArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SWTGuiComposite.this.enteredResponses = SWTGuiComposite.this.getEnteredResponses();
            }
        });
    }

    private void setScrollDimensions(ScrolledComposite scroll, Composite innards) {
        Point parameterAreaSize = innards.computeSize(-1, -1);
        scroll.setMinWidth(parameterAreaSize.x);
        scroll.setMinHeight(parameterAreaSize.y);
    }

    private void setupGUI() {
        this.scrollingArea = new ScrolledComposite(this.parent, 768);
        this.scrollingArea.setLayout((Layout)new GridLayout(1, true));
        this.scrollingArea.setExpandHorizontal(true);
        this.scrollingArea.setExpandVertical(true);
        this.scrollingArea.setAlwaysShowScrollBars(false);
        this.parameterArea = new Composite((Composite)this.scrollingArea, 0);
        this.parameterArea.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(4, 4, true, true);
        this.parameterArea.setLayoutData((Object)gridData);
        GridData userData = new GridData();
        userData.grabExcessVerticalSpace = true;
        userData.grabExcessHorizontalSpace = true;
        userData.verticalAlignment = 4;
        userData.horizontalAlignment = 4;
        this.scrollingArea.setLayoutData((Object)userData);
        this.scrollingArea.setContent((Control)this.parameterArea);
    }

    public ObjectClassDefinition getObjectClassDefinition() {
        return this.objectClassDefinition;
    }

    public Object getResponse(String id) {
        GUIComponent component = this.idToComponentMap.get(id);
        if (component != null) {
            return component.getValue();
        }
        return null;
    }

    public Dictionary<String, Object> getEnteredResponses() {
        return this.enteredResponses;
    }

    public Shell getShell() {
        return this.parent.getShell();
    }

    public Composite getUserArea() {
        return this.parameterArea;
    }

    public Composite getComposite() {
        return this.scrollingArea;
    }

    public String validate() {
        String totalValid = "";
        AttributeDefinition[] attributeDefinitionArray = this.objectClassDefinition.getAttributeDefinitions(1);
        int n = attributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition attribute = attributeDefinitionArray[n2];
            GUIComponent component = this.idToComponentMap.get(attribute.getID());
            String valid = component.validate();
            if (valid != null && valid.length() > 0) {
                totalValid = String.valueOf(totalValid) + "\"" + valid + "\"; ";
            }
            ++n2;
        }
        return totalValid;
    }

    @Override
    public void componentUpdated(GUIComponent component) {
        Object value = component.getValue();
        String valid = component.validate();
        if (value != null && (valid == null || valid.length() == 0)) {
            this.enteredResponses.put(component.getAttributeDefinition().getID(), value);
        } else {
            this.enteredResponses.remove(component.getAttributeDefinition().getID());
        }
        for (UpdateListener listener : this.updateListeners) {
            listener.componentUpdated(component);
        }
    }

    public void addUpdateListener(UpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(UpdateListener listener) {
        this.updateListeners.remove(listener);
    }
}

