/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder;

import java.util.HashSet;
import java.util.Set;
import org.cishell.reference.gui.guibuilder.swt.builder.GUIComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.UpdateListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.metatype.AttributeDefinition;

public abstract class AbstractComponent
implements GUIComponent {
    protected AttributeDefinition attribute;
    protected boolean drawsLabel;
    protected int columnCount;
    protected Set<UpdateListener> listeners;

    @Override
    public abstract void setValue(Object var1);

    @Override
    public abstract Object getValue();

    @Override
    public abstract String validate();

    @Override
    public abstract Control createGUI(Composite var1, int var2);

    public AbstractComponent(boolean drawsLabel, int columnCount) {
        this.drawsLabel = drawsLabel;
        this.columnCount = columnCount;
        this.listeners = new HashSet<UpdateListener>();
    }

    @Override
    public AttributeDefinition getAttributeDefinition() {
        if (this.attribute == null) {
            throw new IllegalStateException("AttributeDefinition has not been set");
        }
        return this.attribute;
    }

    @Override
    public void setAttributeDefinition(AttributeDefinition attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean drawsLabel() {
        return this.drawsLabel;
    }

    @Override
    public int getColumns() {
        return this.columnCount;
    }

    protected void update() {
        for (UpdateListener listener : this.listeners) {
            listener.componentUpdated(this);
        }
    }

    @Override
    public void addUpdateListener(UpdateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUpdateListener(UpdateListener listener) {
        this.listeners.remove(listener);
    }
}

