/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder;

import org.cishell.reference.gui.guibuilder.swt.builder.AbstractComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.GUIComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.components.BooleanComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.components.DirectoryComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.components.FileComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.components.LabelingComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.components.StringComponent;
import org.osgi.service.metatype.AttributeDefinition;

public class ComponentProvider {
    private static final ComponentProvider INSTANCE = new ComponentProvider();

    private ComponentProvider() {
    }

    public static ComponentProvider getInstance() {
        return INSTANCE;
    }

    public GUIComponent createComponent(AttributeDefinition attr) {
        GUIComponent component = this.createBasicComponent(attr);
        component = new LabelingComponent(component);
        return component;
    }

    public GUIComponent createBasicComponent(AttributeDefinition attr) {
        AbstractComponent component = null;
        switch (attr.getType()) {
            case 11: {
                component = new BooleanComponent();
                break;
            }
            case 1: {
                String[] defaultValue = attr.getDefaultValue();
                if (defaultValue != null && defaultValue.length == 1 && defaultValue[0] != null) {
                    if (defaultValue[0].startsWith("file:")) {
                        component = new FileComponent();
                        break;
                    }
                    if (defaultValue[0].startsWith("directory:")) {
                        component = new DirectoryComponent();
                        break;
                    }
                    if (defaultValue[0].startsWith("textarea:")) {
                        component = new StringComponent(true);
                        break;
                    }
                }
            }
            default: {
                component = new StringComponent();
            }
        }
        component.setAttributeDefinition(attr);
        return component;
    }
}

