/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder;

import org.osgi.service.metatype.AttributeDefinition;

public class StringConverter {
    private static final StringConverter INSTANCE = new StringConverter();

    private StringConverter() {
    }

    public static StringConverter getInstance() {
        return INSTANCE;
    }

    public Object stringToObject(AttributeDefinition attr, String string) {
        Object value;
        try {
            switch (attr.getType()) {
                case 1: {
                    value = string;
                    break;
                }
                case 11: {
                    value = new Boolean(string);
                    break;
                }
                case 6: {
                    value = new Byte(string);
                    break;
                }
                case 5: {
                    if (string != null && string.length() == 1) {
                        value = new Character(string.charAt(0));
                        break;
                    }
                    value = null;
                    break;
                }
                case 7: {
                    value = new Double(string);
                    break;
                }
                case 8: {
                    value = new Float(string);
                    break;
                }
                case 2: {
                    value = new Long(string);
                    break;
                }
                case 4: {
                    value = new Short(string);
                    break;
                }
                case 3: {
                    value = new Integer(string);
                    break;
                }
                default: {
                    value = string;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            value = null;
        }
        return value;
    }
}

