/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder.components;

import org.cishell.reference.gui.guibuilder.swt.builder.AbstractComponent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanComponent
extends AbstractComponent {
    Button checkbox;

    public BooleanComponent() {
        super(true, 1);
    }

    @Override
    public Control createGUI(Composite parent, int style) {
        this.checkbox = new Button(parent, 32);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalSpan = 3;
        this.checkbox.setLayoutData((Object)gridData);
        String label = this.attribute.getName();
        if (label != null) {
            this.checkbox.setText(label);
        } else {
            this.checkbox.setText("");
        }
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BooleanComponent.this.update();
            }
        });
        return this.checkbox;
    }

    @Override
    public Object getValue() {
        return this.checkbox.getSelection();
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Boolean && value != null) {
            this.checkbox.setSelection(((Boolean)value).booleanValue());
        } else {
            this.checkbox.setSelection(false);
        }
    }

    @Override
    public String validate() {
        return this.attribute.validate("" + this.checkbox.getSelection());
    }
}

