/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder.components;

import java.io.File;
import org.cishell.reference.gui.guibuilder.swt.builder.components.StringComponent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public class FileComponent
extends StringComponent {
    protected Button browseButton;
    private static Object currentValue;

    public FileComponent() {
        this(false, 2);
    }

    public FileComponent(boolean drawLabel, int numColumns) {
        super(drawLabel, numColumns);
    }

    @Override
    public Control createGUI(Composite parent, int style) {
        super.createGUI(parent, style);
        Object layoutData = this.textField.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            GridData gridData = (GridData)layoutData;
            --gridData.horizontalSpan;
        }
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText("Browse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = FileComponent.this.getFile(FileComponent.this.textField.getText());
                currentValue = FileComponent.fixPath(fileName);
                if (fileName != null) {
                    FileComponent.this.textField.setText(fileName);
                    FileComponent.this.update();
                }
            }
        });
        return this.textField;
    }

    protected String getFile(String defaultPath) {
        FileDialog fileSelectorDialog = new FileDialog(this.textField.getShell(), 4096);
        fileSelectorDialog.setText("Select a File");
        fileSelectorDialog.setFilterPath(defaultPath);
        String chosenFilePath = fileSelectorDialog.open();
        return FileComponent.fixPath(chosenFilePath);
    }

    protected String validate(File file) {
        if (!file.exists() || !file.isFile()) {
            return "Invalid file location";
        }
        return "";
    }

    @Override
    public String validate() {
        File file = new File(this.textField.getText());
        String valid = this.validate(file);
        if (valid.length() > 0) {
            return valid;
        }
        return super.validate();
    }

    protected String getKeyword() {
        return "file:";
    }

    @Override
    public Object getValue() {
        return FileComponent.fixPath(super.getValue().toString());
    }

    @Override
    public void setValue(Object value) {
        if (value != null && value.toString().equals(this.getKeyword())) {
            if (currentValue == null) {
                currentValue = value = new File(System.getProperty("osgi.install.area").replace("file:", "")).getAbsolutePath();
            } else {
                value = currentValue;
            }
        }
        super.setValue(FileComponent.fixPath(value.toString()));
    }

    public static String fixPath(String path) {
        if (path != null) {
            String fixedPath = path.replace('\\', '/');
            return fixedPath;
        }
        return null;
    }
}

