/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder.components;

import org.cishell.reference.gui.guibuilder.swt.builder.AbstractComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.GUIComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.StringConverter;
import org.cishell.reference.gui.guibuilder.swt.builder.UpdateListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LabelingComponent
extends AbstractComponent
implements UpdateListener {
    private static final String DEFAULT_DESCRIPTION_TEXT = "No help text available.";
    private static final Color DESCRIPTION_BGCOLOR = new Color(null, 250, 250, 210);
    private static final int DESCRIPTION_SHELL_LEFT_MARGIN = 12;
    private static final Point DESCRIPTION_SHELL_DIMENSIONS = new Point(250, 30);
    private GUIComponent childComponent;
    private Label label;

    public LabelingComponent(GUIComponent childComponent) {
        super(true, childComponent.getColumns());
        String description;
        this.childComponent = childComponent;
        this.setAttributeDefinition(childComponent.getAttributeDefinition());
        if (!childComponent.drawsLabel()) {
            ++this.columnCount;
        }
        if ((description = this.attribute.getDescription()) != null && description.length() > 0) {
            ++this.columnCount;
        }
        childComponent.addUpdateListener(this);
    }

    @Override
    public Control createGUI(Composite parent, int style) {
        if (this.drawsLabel && !this.childComponent.drawsLabel()) {
            String labelText = this.attribute.getName();
            if (labelText == null) {
                labelText = "";
            }
            this.label = new Label(parent, 0);
            this.label.setText(labelText);
        }
        Control control = this.childComponent.createGUI(parent, style);
        this.setDefaultValue();
        this.createAndAddDescriptionButton(control, parent);
        return control;
    }

    private void createAndAddDescriptionButton(Control control, Composite parent) {
        Button descriptionButton = new Button(parent, 2);
        GridData grid = new GridData(0x1000008, 0x1000000, false, false);
        descriptionButton.setLayoutData((Object)grid);
        Image image = parent.getDisplay().getSystemImage(4);
        Rectangle r = image.getBounds();
        image = new Image(null, image.getImageData().scaledTo(r.width / 2, r.height / 2));
        descriptionButton.setImage(image);
        String descriptionText = this.getDescriptionText();
        if (this.label != null) {
            this.label.setToolTipText(descriptionText);
        } else {
            control.setToolTipText(descriptionText);
        }
        descriptionButton.setToolTipText(descriptionText);
        DescriptionButtonListener listener = new DescriptionButtonListener(descriptionText);
        descriptionButton.addSelectionListener((SelectionListener)listener);
    }

    private void setHoverLocation(Shell descriptionShell, Point position) {
        Rectangle displayBounds = descriptionShell.getDisplay().getBounds();
        Rectangle shellBounds = descriptionShell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x + 12, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y, displayBounds.height - shellBounds.height), 0);
        descriptionShell.setBounds(shellBounds);
    }

    protected void setDefaultValue() {
        String[] defaults = this.attribute.getDefaultValue();
        if (defaults != null && defaults.length > 0) {
            Object value = StringConverter.getInstance().stringToObject(this.attribute, defaults[0]);
            this.setValue(value);
        }
    }

    @Override
    public Object getValue() {
        return this.childComponent.getValue();
    }

    @Override
    public void setValue(Object value) {
        this.childComponent.setValue(value);
    }

    @Override
    public String validate() {
        String valid = this.childComponent.validate();
        if (this.label != null) {
            if (valid != null && valid.length() > 0) {
                this.label.setForeground(ERROR_COLOR);
            } else {
                this.label.setForeground(null);
            }
        }
        return valid;
    }

    @Override
    public void componentUpdated(GUIComponent component) {
        if (!this.childComponent.drawsLabel()) {
            this.validate();
        }
        this.update();
    }

    private String getDescriptionText() {
        String descriptionText = this.attribute.getDescription();
        if (descriptionText == null || descriptionText.length() == 0) {
            descriptionText = DEFAULT_DESCRIPTION_TEXT;
        }
        return descriptionText;
    }

    class DescriptionButtonListener
    implements SelectionListener {
        private Shell descriptionShell = null;
        private String descText;

        DescriptionButtonListener(String descText) {
            this.descText = descText;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Button descriptionButton = (Button)arg0.widget;
            if (descriptionButton.getSelection()) {
                if (this.descriptionShell == null || this.descriptionShell.isDisposed()) {
                    this.descriptionShell = new Shell(descriptionButton.getShell(), 0);
                }
                this.descriptionShell = this.createDescriptionShell(this.descText, descriptionButton);
                Point absoluteShellPosition = descriptionButton.toDisplay(descriptionButton.getBounds().width, 0);
                LabelingComponent.this.setHoverLocation(this.descriptionShell, absoluteShellPosition);
                this.descriptionShell.open();
            } else if (!this.descriptionShell.isDisposed()) {
                this.descriptionShell.close();
            }
        }

        private Shell createDescriptionShell(String descText, Button descriptionButton) {
            Shell descriptionShell = new Shell(descriptionButton.getShell(), 0);
            descriptionShell.setLayout((Layout)new FillLayout());
            descriptionShell.setSize(DESCRIPTION_SHELL_DIMENSIONS);
            Text description = new Text((Composite)descriptionShell, 586);
            description.setText(descText);
            description.setBackground(DESCRIPTION_BGCOLOR);
            descriptionShell.addListener(31, (Listener)new DescriptionShellListener(descriptionButton));
            return descriptionShell;
        }
    }

    class DescriptionShellListener
    implements Listener {
        private Button descriptionButton;

        public DescriptionShellListener(Button descriptionButton) {
            this.descriptionButton = descriptionButton;
        }

        public void handleEvent(Event event) {
            switch (event.detail) {
                case 2: {
                    this.descriptionButton.setSelection(false);
                    break;
                }
            }
        }
    }
}

