/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder.components;

import java.util.Vector;
import org.cishell.reference.gui.guibuilder.swt.builder.AbstractComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.ComponentProvider;
import org.cishell.reference.gui.guibuilder.swt.builder.GUIComponent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.metatype.AttributeDefinition;

public class MultiValuedComponent
extends AbstractComponent {
    protected Composite panel;
    protected Vector componentList = new Vector();
    protected Vector controlList = new Vector();
    protected int maxElements;
    protected int style;

    public MultiValuedComponent(boolean drawsLabel, int numColumns) {
        super(false, 1);
    }

    @Override
    public Control createGUI(Composite parent, int style) {
        this.style = style;
        this.panel = new Composite(parent, style);
        this.panel.setLayout((Layout)new GridLayout(4, false));
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = 2;
        this.panel.setLayoutData((Object)gd);
        this.addComponent(0);
        return this.panel;
    }

    protected synchronized void addComponent(int position) {
        GUIComponent component = ComponentProvider.getInstance().createBasicComponent(this.attribute);
        Control control = component.createGUI(this.panel, this.style);
        this.componentList.add(component);
        this.controlList.add(control);
    }

    protected synchronized GUIComponent getComponent(int position) {
        return (GUIComponent)this.componentList.get(position);
    }

    protected synchronized void removeComponent(int position) {
        if (position < this.componentList.size()) {
            this.componentList.remove(position);
            Control control = (Control)this.controlList.remove(position);
            control.dispose();
        }
    }

    @Override
    public void setAttributeDefinition(AttributeDefinition attr) {
        super.setAttributeDefinition(attr);
        this.maxElements = Math.abs(attr.getCardinality());
        if (this.maxElements == 0) {
            ++this.maxElements;
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public String validate() {
        return null;
    }
}

