/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.guibuilder.swt.builder.components;

import org.cishell.reference.gui.guibuilder.swt.builder.AbstractComponent;
import org.cishell.reference.gui.guibuilder.swt.builder.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class StringComponent
extends AbstractComponent {
    protected Text textField;
    protected Combo combo;
    protected String[] optionValues;
    private boolean multiline;

    public StringComponent() {
        this(false, 1);
    }

    public StringComponent(boolean multiline) {
        this(false, 1);
        this.multiline = multiline;
    }

    public StringComponent(boolean drawLabel, int numColumns) {
        super(drawLabel, numColumns);
    }

    @Override
    public Control createGUI(Composite parent, int style) {
        int flags;
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.horizontalSpan = 2;
        gd.minimumWidth = 100;
        this.optionValues = this.attribute.getOptionValues();
        if (this.optionValues != null) {
            this.combo = new Combo(parent, style | 4 | 8);
            String[] optionLabels = this.attribute.getOptionLabels();
            if (optionLabels == null) {
                this.combo.setItems(this.optionValues);
            } else {
                this.combo.setItems(optionLabels);
            }
            this.combo.select(0);
            this.combo.setLayoutData((Object)gd);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StringComponent.this.update();
                }
            });
            return this.combo;
        }
        if (this.multiline) {
            flags = style | 0x800 | 2 | 0x200;
            gd.minimumHeight = 100;
            gd.minimumWidth = 250;
        } else {
            flags = style | 0x800;
        }
        this.textField = new Text(parent, flags);
        this.textField.setLayoutData((Object)gd);
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                StringComponent.this.update();
            }
        });
        return this.textField;
    }

    @Override
    public Object getValue() {
        Object value = this.combo == null ? StringConverter.getInstance().stringToObject(this.attribute, this.textField.getText()) : StringConverter.getInstance().stringToObject(this.attribute, this.getListValue());
        return value;
    }

    private String getListValue() {
        if (this.optionValues != null) {
            return this.optionValues[this.combo.getSelectionIndex()];
        }
        return "You are not specifying option values, fool!";
    }

    @Override
    public String validate() {
        if (this.getValue() == null) {
            return "Invalid basic value";
        }
        if (this.combo == null) {
            String commaRemoved = this.textField.getText().replace(",", "");
            return this.attribute.validate(commaRemoved);
        }
        return this.attribute.validate(this.getListValue());
    }

    @Override
    public void setValue(Object value) {
        String valueString = this.emptyStringIfNull(value);
        valueString = this.fixTextFieldPrefix("textarea:", valueString);
        valueString = this.fixTextFieldPrefix("file:", valueString);
        valueString = this.fixTextFieldPrefix("directory:", valueString);
        if (this.textField != null) {
            this.textField.setText(valueString);
        } else if (this.combo != null) {
            int setComboToIndex = -1;
            int i = 0;
            while (i < this.optionValues.length) {
                if (valueString.equals(this.optionValues[i])) {
                    setComboToIndex = i;
                }
                ++i;
            }
            if (setComboToIndex != -1) {
                this.combo.select(setComboToIndex);
            }
        }
    }

    private String emptyStringIfNull(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private String fixTextFieldPrefix(String prefix, String value) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }
}

