/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cishell.app.service.datamanager.DataManagerService;
import org.cishell.reference.gui.log.LogToConsole;
import org.cishell.reference.gui.log.LogToFile;
import org.cishell.reference.gui.log.Utilities;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class Activator
extends AbstractUIPlugin {
    private static final String PREFERENCE_SPEPARATOR = "|";
    private static Activator plugin;
    private static BundleContext context;
    LogToFile fileLogger;
    private LogToConsole consoleLogger;
    List<LogReaderService> logReaders = new ArrayList<LogReaderService>();
    public static DataManagerService dataManager;
    private ServiceListener serviceListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            BundleContext bundleContext = event.getServiceReference().getBundle().getBundleContext();
            LogReaderService logReaderService = (LogReaderService)bundleContext.getService(event.getServiceReference());
            if (logReaderService != null) {
                if (event.getType() == 1) {
                    Activator.this.logReaders.add(logReaderService);
                    logReaderService.addLogListener((LogListener)Activator.this.fileLogger);
                } else if (event.getType() == 4) {
                    logReaderService.removeLogListener((LogListener)Activator.this.fileLogger);
                    Activator.this.logReaders.remove(logReaderService);
                }
            }
        }
    };

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        String serviceFilter;
        Collection serviceReferences;
        super.start(bundleContext);
        context = bundleContext;
        PreferencesService preferenceService = (PreferencesService)bundleContext.getService(bundleContext.getServiceReference(PreferencesService.class));
        if (preferenceService != null) {
            Preferences systemPreferences = preferenceService.getSystemPreferences();
            String logDirectory = systemPreferences.get("logDirectory", null);
            String minOSGILevel = systemPreferences.get("minOSGILevel", null);
            String ignoredPrefixes = systemPreferences.get("ignoredPrefixes", null);
            String detailedMessages = systemPreferences.get("detailedMessages", null);
            this.fileLogger = logDirectory != null && minOSGILevel != null ? new LogToFile(logDirectory, Utilities.osgiLevelToJavaLevel(Integer.parseInt(minOSGILevel))) : null;
            this.consoleLogger = detailedMessages != null && minOSGILevel != null && ignoredPrefixes != null ? new LogToConsole(Boolean.parseBoolean(detailedMessages), Integer.parseInt(minOSGILevel), Arrays.asList(ignoredPrefixes.split(PREFERENCE_SPEPARATOR))) : null;
        }
        if (this.fileLogger == null) {
            this.fileLogger = new LogToFile();
        }
        if (this.consoleLogger == null) {
            this.consoleLogger = new LogToConsole(false);
        }
        if ((serviceReferences = bundleContext.getServiceReferences(LogReaderService.class, serviceFilter = null)) != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                LogReaderService reader = (LogReaderService)bundleContext.getService(serviceReference);
                this.logReaders.add(reader);
                reader.addLogListener((LogListener)this.fileLogger);
                reader.addLogListener((LogListener)this.consoleLogger);
            }
            String filter = "(objectclass=" + LogReaderService.class.getName() + ")";
            try {
                context.addServiceListener(this.serviceListener, filter);
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
        dataManager = (DataManagerService)bundleContext.getService(bundleContext.getServiceReference(DataManagerService.class.getName()));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
        context = null;
        if (this.fileLogger != null) {
            for (LogReaderService reader : this.logReaders) {
                reader.removeLogListener((LogListener)this.fileLogger);
                reader.removeLogListener((LogListener)this.consoleLogger);
                this.logReaders.remove(reader);
            }
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static BundleContext getContext() {
        return context;
    }
}

