/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.log;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.cishell.reference.gui.log.Utilities;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LogToConsole
implements LogListener {
    private static final String NEWLINE = System.getProperty("line.separator");
    private boolean detailedMessages;
    private int minLevel;
    private ImmutableCollection<String> ignoredPrefixes;

    public LogToConsole(boolean detailedMessages) {
        this(detailedMessages, 4, (Collection<String>)Utilities.DEFAULT_IGNORED_PREFIXES);
    }

    public LogToConsole(boolean detailedMessages, int minLevel, Collection<String> ignoredPrefixes) {
        if (ignoredPrefixes == null) {
            throw new IllegalArgumentException("ignoredPrefixes must not be null.");
        }
        this.detailedMessages = detailedMessages;
        this.minLevel = minLevel;
        this.ignoredPrefixes = ImmutableList.copyOf(ignoredPrefixes);
    }

    public void logged(LogEntry entry) {
        if (!Utilities.shouldLogMessage(entry, this.ignoredPrefixes)) {
            return;
        }
        if (entry.getLevel() > this.minLevel) {
            return;
        }
        String level = "";
        switch (entry.getLevel()) {
            case 4: {
                level = "DEBUG";
                break;
            }
            case 1: {
                level = "ERROR";
                break;
            }
            case 3: {
                level = "INFO";
                break;
            }
            case 2: {
                level = "WARNING";
                break;
            }
            default: {
                level = "UNKNOWN LEVEL";
            }
        }
        StringBuilder logEntry = new StringBuilder();
        if (this.detailedMessages) {
            logEntry.append("[" + entry.getBundle().getSymbolicName() + "]: ");
            logEntry.append(String.valueOf(level) + " " + entry.getMessage());
            if (entry.getException() != null) {
                logEntry.append(String.valueOf(NEWLINE) + "Exception: " + NEWLINE);
                logEntry.append(entry.getException());
            }
        } else {
            logEntry.append(String.valueOf(level) + ": " + entry.getMessage());
        }
        System.out.println(logEntry.toString());
    }
}

