/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.log;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.cishell.reference.gui.log.Utilities;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LogToFile
implements LogListener {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int LIMIT_PER_FILE = 0x500000;
    private static final int MAX_NUM_LOG_FILES = 5;
    private static final boolean APPEND = true;
    private static final boolean SEND_TO_PARENT_LOGGER = false;
    private static final String LOGGER_NAME = "org.cishell.reference.gui.log.file";
    private static final String DEFAULT_LOG_DIRECTORY = String.valueOf(System.getProperty("user.dir")) + File.separator + "logs";
    private static final String LOG_PREFIX = "cishell-user-";
    private Logger logger;

    public LogToFile() throws LogToFileCreationException {
        this(DEFAULT_LOG_DIRECTORY, Level.ALL);
    }

    public LogToFile(String directory, Level minLevel) throws LogToFileCreationException {
        try {
            LogToFile.validateDirectory(directory);
            String logPattern = String.valueOf(directory) + File.separator + LOG_PREFIX + LogToFile.getTimestamp() + ".%u.%g.log";
            FileHandler handler = new FileHandler(logPattern, 0x500000, 5, true);
            handler.setFormatter(new SimpleFormatter());
            this.logger = Logger.getLogger(LOGGER_NAME);
            this.logger.addHandler(handler);
            this.logger.setUseParentHandlers(false);
            this.logger.setLevel(minLevel);
        }
        catch (InvalidDirectoryException e) {
            throw new LogToFileCreationException("The LogToFile logger could not be created.", e);
        }
        catch (SecurityException e) {
            throw new LogToFileCreationException("The LogToFile logger could not be created.", e);
        }
        catch (IOException e) {
            throw new LogToFileCreationException("The LogToFile logger could not be created.", e);
        }
    }

    private static void validateDirectory(String directoryPathname) throws InvalidDirectoryException {
        File file = new File(directoryPathname);
        if (file.exists()) {
            if (file.isDirectory()) {
                return;
            }
            throw new InvalidDirectoryException("There is a file, not a directory at '" + directoryPathname + "'.");
        }
        if (!file.mkdirs()) {
            throw new InvalidDirectoryException("The file directory did not exist, but could not be made at '" + directoryPathname + "'.");
        }
    }

    public void logged(LogEntry entry) {
        if (!Utilities.shouldLogMessage(entry, Utilities.DEFAULT_IGNORED_PREFIXES)) {
            return;
        }
        Level level = Utilities.osgiLevelToJavaLevel(entry.getLevel());
        String logEntry = "";
        logEntry = String.valueOf(logEntry) + entry.getMessage() + NEWLINE;
        if (entry.getException() != null) {
            logEntry = String.valueOf(logEntry) + "Exception: " + NEWLINE + entry.getException();
        }
        this.logger.log(level, logEntry);
    }

    private static String getTimestamp() {
        String dateFormat = "MM-dd-yyyy-hh-mm-a";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        String timestamp = simpleDateFormat.format(Calendar.getInstance().getTime());
        return timestamp;
    }

    private static class InvalidDirectoryException
    extends Exception {
        private static final long serialVersionUID = 6314769551833577561L;

        protected InvalidDirectoryException(String message) {
            super(message);
        }
    }

    public static class LogToFileCreationException
    extends Exception {
        private static final long serialVersionUID = -5837126430378342519L;

        public LogToFileCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

