/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.log;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.cishell.app.service.datamanager.DataManagerListener;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.log.Activator;
import org.cishell.utility.swt.SWTUtilities;
import org.cishell.utility.swt.URLClickedListener;
import org.cishell.utility.swt.URLMouseCursorListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class LogView
extends ViewPart
implements DataManagerListener,
LogListener {
    public static final String CONFIGURATION_DIRECTORY = "configuration";
    public static final String WELCOME_TEXT_FILE_NAME = "Welcome.properties";
    public static final String GREETING_PROPERTY = "greeting";
    public static final Color URL_COLOR = LogView.getSystemColor(9);
    public static final Color LOG_ERROR_COLOR = LogView.getSystemColor(3);
    public static final Color LOG_WARNING_COLOR = new Color((Device)Display.getDefault(), 255, 127, 0);
    public static final Color LOG_INFO_COLOR = LogView.getSystemColor(2);
    public static final Color LOG_DEBUG_COLOR = new Color((Device)Display.getDefault(), 150, 150, 150);
    public static final Color UNHIGHLIGHED_BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 255, 255, 255);
    public static final Color HIGHLIGHTED_BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 200, 200, 200);
    public static final boolean HIGHLIGHT_TEXT = false;
    private Multimap<ServiceReference, Bounds> boundsByServiceReference = HashMultimap.create();
    private Collection<StyleRange> nonHighlightStyleRanges = new HashSet<StyleRange>();
    public static final Map<String, Color> COLOR_MAPPING = LogView.getColorMapping();
    private Composite parent;
    private StyledText textField;
    private URLClickedListener urlListener;
    private URLMouseCursorListener urlCursorListener;

    public void dataAdded(Data data, String label) {
    }

    public void dataLabelChanged(Data data, String label) {
    }

    public void dataRemoved(Data data) {
    }

    public void dataSelected(Data[] data) {
    }

    private static Color getSystemColor(final int swtColor) {
        final Color[] color = new Color[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                color[0] = Display.getDefault().getSystemColor(swtColor);
            }
        });
        return color[0];
    }

    private static Map<String, Color> getColorMapping() {
        HashMap<String, Color> colorMapping = new HashMap<String, Color>();
        colorMapping.put("4", LOG_DEBUG_COLOR);
        colorMapping.put("3", LOG_INFO_COLOR);
        colorMapping.put("2", LOG_WARNING_COLOR);
        colorMapping.put("1", LOG_ERROR_COLOR);
        return Collections.unmodifiableMap(colorMapping);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.textField = new StyledText(parent, 2632);
        this.textField.setEditable(false);
        this.textField.setBackground(parent.getDisplay().getSystemColor(1));
        this.textField.getCaret().setVisible(false);
        this.urlListener = new URLClickedListener(this.textField);
        this.textField.addMouseListener((MouseListener)this.urlListener);
        this.urlCursorListener = new URLMouseCursorListener(this.parent, this.textField);
        this.textField.addMouseMoveListener((MouseMoveListener)this.urlCursorListener);
        Display display = Display.getDefault();
        final Clipboard clipboard = new Clipboard(display);
        final Menu menu = new Menu((Control)this.textField);
        menu.setVisible(false);
        MenuItem actionItem = new MenuItem(menu, 8);
        actionItem.setText("Copy");
        actionItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String textData = LogView.this.textField.getSelectionText();
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{textData}, new Transfer[]{textTransfer});
            }
        });
        this.textField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selection = ((StyledText)event.widget).getSelectionText();
                if (selection.equals("")) {
                    LogView.this.textField.setMenu(null);
                } else {
                    LogView.this.textField.setMenu(menu);
                }
            }
        });
        BundleContext context = Activator.getContext();
        ServiceReference logReaderServiceReference = context.getServiceReference(LogReaderService.class.getName());
        LogReaderService logReaderService = (LogReaderService)context.getService(logReaderServiceReference);
        if (logReaderService != null) {
            logReaderService.addLogListener((LogListener)this);
            Enumeration backLogEntries = logReaderService.getLog();
            while (backLogEntries.hasMoreElements()) {
                LogEntry logEntry = (LogEntry)backLogEntries.nextElement();
                this.logged(logEntry);
            }
        } else {
            System.out.println("reader is null");
        }
        ServiceReference logServiceReference = context.getServiceReference(LogService.class.getName());
        LogService logService = (LogService)context.getService(logServiceReference);
        if (logService != null) {
            try {
                URL welcomeTextFileURL = new URL(new URL(System.getProperty("osgi.configuration.area")), WELCOME_TEXT_FILE_NAME);
                Properties properties = new Properties();
                properties.load(welcomeTextFileURL.openStream());
                String greetingText = properties.getProperty(GREETING_PROPERTY, null);
                logService.log(3, greetingText);
            }
            catch (IOException e) {
                System.err.println("Error reading Welcome properties file: " + e.getMessage());
            }
        } else {
            try {
                FileWriter fstream = new FileWriter("WelcomeTextError.txt", true);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write("The Log Service cannot be found.\r\n");
                out.close();
            }
            catch (Exception e) {
                System.err.println("Error writing to file: " + e.getMessage());
            }
        }
    }

    public void setFocus() {
        this.textField.setFocus();
    }

    public void logged(final LogEntry entry) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String message = entry.getMessage();
                    if (LogView.this.goodEntry(entry)) {
                        if (!message.endsWith("\n")) {
                            message = String.valueOf(message) + "\n";
                        }
                        Collection collection = SWTUtilities.urlifyUrls((StyledText)LogView.this.textField, (URLClickedListener)LogView.this.urlListener, (URLMouseCursorListener)LogView.this.urlCursorListener, (String)message, (Color)COLOR_MAPPING.get("" + entry.getLevel()), (Color)URL_COLOR);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean goodEntry(LogEntry entry) {
        Bundle sourceBundle = entry.getBundle();
        if (sourceBundle != null && sourceBundle.getSymbolicName().startsWith("org.eclipse.equinox.metatype")) {
            return false;
        }
        if (entry.getLevel() >= 4) {
            return false;
        }
        String msg = entry.getMessage();
        return msg != null && !msg.startsWith("ServiceEvent ") && !msg.startsWith("BundleEvent ") && !msg.startsWith("FrameworkEvent ");
    }

    private static class Bounds {
        public int start;
        public int length;

        public Bounds(int start, int end) {
            this.start = start;
            this.length = end;
        }
    }
}

