/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.log;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.logging.Level;
import org.osgi.service.log.LogEntry;

public class Utilities {
    public static final ImmutableList<String> DEFAULT_IGNORED_PREFIXES = ImmutableList.of((Object)"ServiceEvent ", (Object)"BundleEvent ", (Object)"FrameworkEvent ");

    private Utilities() {
        throw new AssertionError();
    }

    public static boolean shouldLogMessage(LogEntry entry, Collection<String> ignoredPrefixes) {
        if (entry == null) {
            return false;
        }
        if (entry.getMessage() == null) {
            return false;
        }
        if (ignoredPrefixes == null) {
            return true;
        }
        for (String messagePrefix : ignoredPrefixes) {
            if (!entry.getMessage().startsWith(messagePrefix)) continue;
            return false;
        }
        return true;
    }

    public static Level osgiLevelToJavaLevel(int osgiLevel) {
        switch (osgiLevel) {
            case 4: {
                return Level.FINEST;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 3: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARNING;
            }
        }
        return Level.SEVERE;
    }
}

