/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.menumanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.LocalCIShellContext;
import org.cishell.reference.gui.menumanager.menu.MenuAdapter;
import org.cishell.reference.gui.workspace.CIShellApplication;
import org.cishell.utilities.StringUtilities;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.cishell.reference.gui.menumanager";
    public static final String CONFIGURATION_DIRECTORY = "configuration";
    public static final String WELCOME_TEXT_FILE_NAME = "Welcome.properties";
    public static final String DEFAULT_TOOL_NAME = "CIShell";
    public static final String TOOL_NAME_PROPERTY = "toolName";
    public static final String DEFAULT_TOOL_TICKET_URL = "http://cns-jira.slis.indiana.edu/secure/CreateIssue.jspa?issuetype=1";
    public static final String TOOL_TICKET_URL_PROPERTY = "toolTicketURL";
    private static Activator plugin;
    private static BundleContext bundleContext;
    private MenuAdapter menuAdapter;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        Activator.bundleContext = bundleContext;
        while (this.getWorkbench() == null) {
            Thread.sleep(500L);
        }
        IWorkbenchWindow[] windows = this.getWorkbench().getWorkbenchWindows();
        while (windows.length == 0) {
            Thread.sleep(500L);
            windows = this.getWorkbench().getWorkbenchWindows();
        }
        Shell shell = windows[0].getShell();
        IMenuManager menuManager = CIShellApplication.getMenuManager();
        LocalCIShellContext ciShellContext = new LocalCIShellContext(bundleContext);
        Properties properties = Activator.getProperties();
        String toolName = Activator.getToolName(properties);
        String toolTicketURL = Activator.getToolTicketURL(properties);
        this.menuAdapter = new MenuAdapter(toolName, toolTicketURL, menuManager, shell, bundleContext, (CIShellContext)ciShellContext, windows[0]);
        try {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SWT_AWT.new_Frame((Composite)new Shell(0x1000000));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.menuAdapter = null;
        super.stop(context);
    }

    public static Object getService(String servicePID) {
        ServiceReference serviceReference = bundleContext.getServiceReference(servicePID);
        if (serviceReference != null) {
            return bundleContext.getService(serviceReference);
        }
        return null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void earlyStartup() {
    }

    private static Properties getProperties() {
        Properties brandBundleProperties = new Properties();
        try {
            URI welcomeTextFileURI = new URI(System.getProperty("osgi.configuration.area")).resolve(WELCOME_TEXT_FILE_NAME);
            InputStream fileStream = welcomeTextFileURI.toURL().openStream();
            brandBundleProperties.load(fileStream);
            fileStream.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            brandBundleProperties = new Properties();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            brandBundleProperties = new Properties();
        }
        return brandBundleProperties;
    }

    private static String getToolName(Properties properties) {
        String toolName = properties.getProperty(TOOL_NAME_PROPERTY);
        if (!StringUtilities.isNull_Empty_OrWhitespace((String)toolName)) {
            return toolName;
        }
        return DEFAULT_TOOL_NAME;
    }

    private static String getToolTicketURL(Properties properties) {
        String toolTicketURL = properties.getProperty(TOOL_TICKET_URL_PROPERTY);
        if (!StringUtilities.isNull_Empty_OrWhitespace((String)toolTicketURL)) {
            return toolTicketURL;
        }
        return DEFAULT_TOOL_TICKET_URL;
    }
}

