/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.menumanager.menu;

import java.util.ArrayList;
import java.util.Arrays;
import org.cishell.app.service.datamanager.DataManagerListener;
import org.cishell.app.service.datamanager.DataManagerService;
import org.cishell.app.service.scheduler.SchedulerService;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmProperty;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.menumanager.menu.AlgorithmWrapper;
import org.cishell.service.conversion.Converter;
import org.cishell.service.conversion.DataConversionService;
import org.eclipse.jface.action.Action;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class AlgorithmAction
extends Action
implements AlgorithmProperty,
DataManagerListener {
    protected CIShellContext ciShellContext;
    protected BundleContext bundleContext;
    protected ServiceReference serviceReference;
    protected Data[] data;
    protected Data[] originalData;
    protected Converter[][] converters;

    public AlgorithmAction(ServiceReference serviceReference, BundleContext bundleContext, CIShellContext ciShellContext) {
        this((String)serviceReference.getProperty("label"), serviceReference, bundleContext, ciShellContext);
    }

    public AlgorithmAction(String label, ServiceReference serviceReference, BundleContext bundleContext, CIShellContext ciShellContext) {
        this.serviceReference = serviceReference;
        this.ciShellContext = ciShellContext;
        this.bundleContext = bundleContext;
        this.setText(label);
        this.setToolTipText((String)serviceReference.getProperty("description"));
        DataManagerService dataManager = (DataManagerService)bundleContext.getService(bundleContext.getServiceReference(DataManagerService.class.getName()));
        dataManager.addDataManagerListener((DataManagerListener)this);
        this.dataSelected(dataManager.getSelectedData());
    }

    public void run() {
        try {
            ServiceReference uniqueServiceReference = this.serviceReference;
            this.printAlgorithmInformation(uniqueServiceReference, this.ciShellContext);
            AlgorithmWrapper algorithm = new AlgorithmWrapper(uniqueServiceReference, this.bundleContext, this.ciShellContext, this.originalData, this.data, this.converters);
            SchedulerService scheduler = (SchedulerService)this.getService(SchedulerService.class);
            scheduler.schedule((Algorithm)algorithm, uniqueServiceReference);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
    }

    private void printAlgorithmInformation(ServiceReference serviceReference, CIShellContext ciContext) {
        String integrators;
        String implementers;
        String authors;
        LogService logger = (LogService)ciContext.getService(LogService.class.getName());
        StringBuffer acknowledgement = new StringBuffer();
        String label = (String)serviceReference.getProperty("label");
        if (label != null) {
            acknowledgement.append("..........\n" + label + " was selected.\n");
        }
        if ((authors = (String)serviceReference.getProperty("authors")) != null) {
            acknowledgement.append("Author(s): " + authors + "\n");
        }
        if ((implementers = (String)serviceReference.getProperty("implementers")) != null) {
            acknowledgement.append("Implementer(s): " + implementers + "\n");
        }
        if ((integrators = (String)serviceReference.getProperty("integrators")) != null) {
            acknowledgement.append("Integrator(s): " + integrators + "\n");
        }
        String reference = (String)serviceReference.getProperty("reference");
        String reference_url = (String)serviceReference.getProperty("reference_url");
        if (reference != null && reference_url != null) {
            acknowledgement.append("Reference: " + reference + " ([url]" + reference_url + "[/url])\n");
        } else if (reference != null && reference_url == null) {
            acknowledgement.append("Reference: " + reference + "\n");
        }
        String documentationURL = (String)serviceReference.getProperty("documentation_url");
        if (documentationURL != null) {
            acknowledgement.append("Documentation: [url]" + documentationURL + "[/url]\n");
        }
        if (acknowledgement.length() > 1) {
            logger.log(serviceReference, 3, acknowledgement.toString());
        }
    }

    private String[] separateInData(String inDataString) {
        String[] inData = inDataString.split(",");
        int ii = 0;
        while (ii < inData.length) {
            inData[ii] = inData[ii].trim();
            ++ii;
        }
        return inData;
    }

    public void dataSelected(Data[] selectedData) {
        String inDataString = (String)this.serviceReference.getProperty("in_data");
        String[] inData = this.separateInData(inDataString);
        if (inData.length == 1 && inData[0].equalsIgnoreCase("null")) {
            this.data = new Data[0];
        } else if (selectedData == null) {
            this.data = null;
        } else {
            DataConversionService converter = (DataConversionService)this.ciShellContext.getService(DataConversionService.class.getName());
            ArrayList<Data> dataSet = new ArrayList<Data>(Arrays.asList(selectedData));
            this.data = new Data[inData.length];
            this.converters = new Converter[inData.length][];
            int ii = 0;
            while (ii < inData.length) {
                int jj = 0;
                while (jj < dataSet.size()) {
                    Data datum = (Data)dataSet.get(jj);
                    if (datum != null) {
                        if (this.isAssignableFrom(inData[ii], datum)) {
                            dataSet.remove(jj);
                            this.data[ii] = datum;
                            this.converters[ii] = null;
                        } else {
                            Converter[] conversion = converter.findConverters(datum, inData[ii]);
                            if (conversion.length > 0) {
                                dataSet.remove(jj);
                                this.data[ii] = datum;
                                this.converters[ii] = conversion;
                            }
                        }
                    }
                    ++jj;
                }
                if (this.data[ii] == null) {
                    this.data = null;
                    break;
                }
                ++ii;
            }
        }
        this.originalData = this.data != null ? (Data[])this.data.clone() : null;
        this.setEnabled(this.data != null);
    }

    private boolean isAssignableFrom(String type, Data datum) {
        Object data = datum.getData();
        boolean assignable = false;
        if (type != null && type.equalsIgnoreCase(datum.getFormat())) {
            assignable = true;
        } else if (data != null) {
            try {
                Class<?> clazz = Class.forName(type, false, data.getClass().getClassLoader());
                if (clazz != null && clazz.isInstance(data)) {
                    assignable = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return assignable;
    }

    public void dataAdded(Data data, String label) {
    }

    public void dataLabelChanged(Data data, String label) {
    }

    public void dataRemoved(Data data) {
    }

    private Object getService(Class<?> clazz) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(clazz.getName());
        if (serviceReference != null) {
            return this.bundleContext.getService(serviceReference);
        }
        return null;
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }
}

