/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.menumanager.menu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.cishell.app.service.datamanager.DataManagerService;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.CIShellContextDelegate;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCanceledException;
import org.cishell.framework.algorithm.AlgorithmCreationCanceledException;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.AlgorithmProperty;
import org.cishell.framework.algorithm.AllParametersMutatedOutException;
import org.cishell.framework.algorithm.DataValidator;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.Data;
import org.cishell.reference.gui.menumanager.Activator;
import org.cishell.reference.gui.menumanager.menu.metatypewrapper.ParamMetaTypeProvider;
import org.cishell.reference.service.metatype.BasicMetaTypeProvider;
import org.cishell.service.conversion.ConversionException;
import org.cishell.service.conversion.Converter;
import org.cishell.service.guibuilder.GUIBuilderService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class AlgorithmWrapper
implements Algorithm,
AlgorithmProperty,
ProgressTrackable {
    protected ServiceReference serviceReference;
    protected BundleContext bundleContext;
    protected CIShellContext ciShellContext;
    protected Data[] originalData;
    protected Data[] data;
    protected Converter[][] converters;
    protected ProgressMonitor progressMonitor;
    protected Algorithm algorithm;
    protected Dictionary<String, Object> parameters;

    public AlgorithmWrapper(ServiceReference serviceReference, BundleContext bundleContext, CIShellContext ciShellContext, Data[] originalData, Data[] data, Converter[][] converters) {
        this.serviceReference = serviceReference;
        this.bundleContext = bundleContext;
        this.ciShellContext = ciShellContext;
        this.originalData = originalData;
        this.data = data;
        this.converters = converters;
        this.progressMonitor = null;
    }

    public Dictionary<String, Object> getParameters() {
        return this.cloneDictionary(this.parameters);
    }

    private <K, V> Dictionary<K, V> cloneDictionary(Dictionary<K, V> source) {
        Hashtable<K, V> cloned = new Hashtable<K, V>();
        Enumeration<K> keys = source.keys();
        while (keys.hasMoreElements()) {
            K key = keys.nextElement();
            ((Dictionary)cloned).put(key, source.get(key));
        }
        return cloned;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Data[] execute() throws AlgorithmExecutionException {
        try {
            AlgorithmFactory factory = this.getAlgorithmFactory(this.bundleContext, this.serviceReference);
            if (factory == null) {
                return null;
            }
            String pid = (String)this.serviceReference.getProperty("service.pid");
            boolean conversionSuccessful = this.tryConvertingDataToRequiredFormat(this.data, this.converters);
            if (!conversionSuccessful) {
                return null;
            }
            boolean inputIsValid = this.testDataValidityIfPossible(factory, this.data);
            if (!inputIsValid) {
                return null;
            }
            String metatypePID = this.getMetaTypeID(this.serviceReference);
            MetaTypeProvider provider = null;
            try {
                provider = this.getPossiblyMutatedMetaTypeProvider(metatypePID, pid, factory);
            }
            catch (AlgorithmCreationFailedException e) {
                String format = "An error occurred when creating the algorithm \"%s\" with the data you provided.  (Reason: %s)";
                String logMessage = String.format(format, this.serviceReference.getProperty("label"), e.getMessage());
                this.log(1, logMessage, e);
                return null;
            }
            catch (Exception e) {
                this.log(1, e.getMessage(), e);
                return null;
            }
            this.parameters = this.getUserEnteredParameters(metatypePID, provider);
            if (this.parameters == null) {
                return null;
            }
            this.printParameters(metatypePID, provider, this.parameters);
            this.algorithm = this.createAlgorithm(factory, this.data, this.parameters, (CIShellContext)new CIShellContextDelegate(this.serviceReference, this.ciShellContext));
            if (this.algorithm == null) {
                return null;
            }
            this.trackAlgorithmIfPossible(this.algorithm);
            Data[] outData = this.tryExecutingAlgorithm(this.algorithm);
            if (outData == null) {
                return null;
            }
            Data[] dataArray = outData;
            int n = outData.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.doParentage(outData);
                    outData = this.removeNullData(outData);
                    this.addDataToDataManager(outData);
                    return outData;
                }
                Data datum = dataArray[n2];
                datum.getMetadata().put("ServiceReference", this.serviceReference);
                ++n2;
            }
        }
        catch (Exception e) {
            GUIBuilderService builder = (GUIBuilderService)this.ciShellContext.getService(GUIBuilderService.class.getName());
            String errorMessage = "An error occurred while preparing to run the algorithm \"" + this.serviceReference.getProperty("label") + ".\"";
            builder.showError("Error!", errorMessage, (Throwable)e);
            this.log(1, errorMessage, e);
            return null;
        }
    }

    protected AlgorithmFactory getAlgorithmFactory(BundleContext bundleContext, ServiceReference serviceReference) {
        AlgorithmFactory algorithmFactory = (AlgorithmFactory)bundleContext.getService(serviceReference);
        if (algorithmFactory == null) {
            String errorMessage = "Could not create AlgorithmFactory for the algorithm \"" + serviceReference.getProperty("label") + "\".";
            String details = "The algorithm's pid was \"" + serviceReference.getProperty("service.pid") + "\" (potentially useful for debugging purposes).";
            GUIBuilderService builder = (GUIBuilderService)this.ciShellContext.getService(GUIBuilderService.class.getName());
            builder.showError("Error!", errorMessage, details);
            this.log(1, errorMessage);
        }
        return algorithmFactory;
    }

    protected Algorithm createAlgorithm(AlgorithmFactory factory, Data[] data, Dictionary<String, Object> parameters, CIShellContext ciContext) {
        String algorithmName = (String)this.serviceReference.getProperty("label");
        try {
            return factory.createAlgorithm(data, parameters, ciContext);
        }
        catch (AlgorithmCreationCanceledException e) {
            String logMessage = String.format("The algorithm \"%s\" was canceled by the user.", algorithmName, e.getMessage());
            this.log(2, logMessage, e);
            return null;
        }
        catch (AlgorithmCreationFailedException e) {
            String format = "An error occurred when creating algorithm \"%s\".  (Reason: %s)";
            String errorMessage = String.format(format, algorithmName, e.getMessage());
            GUIBuilderService builder = (GUIBuilderService)ciContext.getService(GUIBuilderService.class.getName());
            builder.showError("Error!", errorMessage, (Throwable)e);
            this.log(1, errorMessage, e);
            return null;
        }
        catch (Exception e) {
            String errorMessage = String.format("Unexpected error occurred while creating algorithm \"%s\".", algorithmName);
            GUIBuilderService builder = (GUIBuilderService)ciContext.getService(GUIBuilderService.class.getName());
            builder.showError("Error!", errorMessage, (Throwable)e);
            this.log(1, errorMessage, e);
            return null;
        }
    }

    protected Data[] removeNullData(Data[] outData) {
        if (outData != null) {
            ArrayList<Data> goodData = new ArrayList<Data>();
            Data[] dataArray = outData;
            int n = outData.length;
            int n2 = 0;
            while (n2 < n) {
                Data data = dataArray[n2];
                if (data != null) {
                    goodData.add(data);
                }
                ++n2;
            }
            outData = goodData.toArray(new Data[0]);
        }
        return outData;
    }

    protected void addDataToDataManager(Data[] outData) {
        if (outData != null) {
            DataManagerService dataManager = (DataManagerService)this.bundleContext.getService(this.bundleContext.getServiceReference(DataManagerService.class.getName()));
            if (outData.length != 0) {
                int ii = 0;
                while (ii < outData.length) {
                    dataManager.addData(outData[ii]);
                    ++ii;
                }
                Data[] dataToSelect = new Data[]{outData[0]};
                dataManager.setSelectedData(dataToSelect);
            }
        }
    }

    protected Data[] tryExecutingAlgorithm(Algorithm algorithm) {
        Data[] outData = null;
        String algorithmName = (String)this.serviceReference.getProperty("label");
        try {
            outData = algorithm.execute();
        }
        catch (AlgorithmCanceledException e) {
            String logMessage = String.format("The algorithm: \"%s\" was canceled by the user.", algorithmName, e.getMessage());
            this.log(2, logMessage, e);
        }
        catch (AlgorithmExecutionException e) {
            String logMessage = String.format("The algorithm: \"%s\" had an error while executing: %s", algorithmName, e.getMessage());
            this.log(1, logMessage, e);
        }
        catch (RuntimeException e) {
            GUIBuilderService builder = (GUIBuilderService)this.ciShellContext.getService(GUIBuilderService.class.getName());
            String errorMessage = String.format("An unxpected error occurred while executing the algorithm \"%s\".", algorithmName);
            builder.showError("Error!", errorMessage, (Throwable)e);
        }
        return outData;
    }

    protected boolean tryConvertingDataToRequiredFormat(Data[] data, Converter[][] converters) {
        int i = 0;
        while (i < data.length) {
            if (converters[i] != null) {
                try {
                    data[i] = converters[i][0].convert(data[i]);
                }
                catch (ConversionException e) {
                    String logMessage = String.format("Error: Unable to convert data for use by the algorithm:%n    %s", e.getMessage());
                    this.log(1, logMessage, e);
                    e.printStackTrace();
                    return false;
                }
                if (data[i] == null && i < data.length - 1) {
                    this.log(1, "The converter: " + converters[i].getClass().getName() + " returned a null result where data was " + "expected when converting the data to give " + "the algorithm.");
                    return false;
                }
                converters[i] = null;
            }
            ++i;
        }
        return true;
    }

    protected boolean testDataValidityIfPossible(AlgorithmFactory factory, Data[] data) {
        String validation;
        if (factory instanceof DataValidator && (validation = ((DataValidator)factory).validate(data)) != null && validation.length() > 0) {
            String label = (String)this.serviceReference.getProperty("label");
            if (label == null) {
                label = "Algorithm";
            }
            this.log(1, "INVALID DATA: The data given to \"" + label + "\" is incompatible for this reason: " + validation);
            return false;
        }
        return true;
    }

    protected String getMetaTypeID(ServiceReference ref) {
        String pid = (String)ref.getProperty("service.pid");
        String metatype_pid = (String)ref.getProperty("parameters_pid");
        if (metatype_pid == null) {
            metatype_pid = pid;
        }
        return metatype_pid;
    }

    protected MetaTypeProvider getPossiblyMutatedMetaTypeProvider(String metatypePID, String pid, AlgorithmFactory factory) throws AlgorithmCreationFailedException {
        MetaTypeInformation provider = null;
        MetaTypeService metaTypeService = (MetaTypeService)Activator.getService(MetaTypeService.class.getName());
        if (metaTypeService != null) {
            provider = metaTypeService.getMetaTypeInformation(this.serviceReference.getBundle());
        }
        if (factory instanceof ParameterMutator && provider != null) {
            try {
                ObjectClassDefinition objectClassDefinition = provider.getObjectClassDefinition(metatypePID, null);
                if (objectClassDefinition == null) {
                    this.logNullOCDWarning(pid, metatypePID);
                }
                try {
                    objectClassDefinition = ((ParameterMutator)factory).mutateParameters(this.data, objectClassDefinition);
                    if (objectClassDefinition != null) {
                        provider = new BasicMetaTypeProvider(objectClassDefinition);
                    }
                }
                catch (AllParametersMutatedOutException allParametersMutatedOutException) {
                    provider = null;
                }
            }
            catch (IllegalArgumentException e) {
                this.log(4, String.valueOf(pid) + " has an invalid metatype id: " + metatypePID, e);
            }
        }
        if (provider != null) {
            provider = this.wrapProvider(this.serviceReference, (MetaTypeProvider)provider);
        }
        return provider;
    }

    protected void trackAlgorithmIfPossible(Algorithm algorithm) {
        if (this.progressMonitor != null && algorithm instanceof ProgressTrackable) {
            ((ProgressTrackable)algorithm).setProgressMonitor(this.progressMonitor);
        }
    }

    protected Dictionary<String, Object> getUserEnteredParameters(String metatypePID, MetaTypeProvider provider) {
        Dictionary parameters = new Hashtable<String, Object>();
        if (provider != null) {
            GUIBuilderService builder = (GUIBuilderService)this.ciShellContext.getService(GUIBuilderService.class.getName());
            parameters = builder.createGUIandWait(metatypePID, provider);
        }
        return parameters;
    }

    protected MetaTypeProvider wrapProvider(ServiceReference algRef, MetaTypeProvider unwrappedProvider) {
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (ca != null && this.hasParamDefaultPreferences(algRef)) {
            String standardServicePID = (String)algRef.getProperty("service.pid");
            String paramOverrideConfPID = String.valueOf(standardServicePID) + ".prefs.params";
            try {
                Configuration defaultParamValueOverrider = ca.getConfiguration(paramOverrideConfPID, null);
                Dictionary defaultParamOverriderDict = defaultParamValueOverrider.getProperties();
                ParamMetaTypeProvider wrappedProvider = new ParamMetaTypeProvider(unwrappedProvider, defaultParamOverriderDict);
                return wrappedProvider;
            }
            catch (IOException iOException) {
                return unwrappedProvider;
            }
        }
        return unwrappedProvider;
    }

    protected boolean hasParamDefaultPreferences(ServiceReference algRef) {
        String prefsToPublish = (String)algRef.getProperty("prefs_published");
        if (prefsToPublish == null) {
            return false;
        }
        return prefsToPublish.contains("param-defaults");
    }

    protected void log(int logLevel, String message) {
        LogService logger = (LogService)this.ciShellContext.getService(LogService.class.getName());
        if (logger != null) {
            logger.log(this.serviceReference, logLevel, message);
        } else {
            System.out.println(message);
        }
    }

    protected void log(int logLevel, String message, Throwable exception) {
        LogService logger = (LogService)this.ciShellContext.getService(LogService.class.getName());
        if (logger != null) {
            logger.log(this.serviceReference, logLevel, message, exception);
        } else {
            System.out.println(message);
            exception.printStackTrace();
        }
    }

    protected void printParameters(String metatype_pid, MetaTypeProvider provider, Dictionary parameters) {
        LogService logger = this.getLogService();
        Map idToLabelMap = this.setupIdToLabelMap(metatype_pid, provider);
        if (logger != null && !parameters.isEmpty()) {
            StringBuffer inputParams = new StringBuffer("\nInput Parameters:");
            Enumeration e = parameters.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = parameters.get(key);
                key = (String)idToLabelMap.get(key);
                inputParams.append("\n" + key + ": " + value);
            }
            logger.log(this.serviceReference, 3, inputParams.toString());
        }
    }

    protected Map setupIdToLabelMap(String metatype_pid, MetaTypeProvider provider) {
        HashMap<String, String> idToLabelMap = new HashMap<String, String>();
        if (provider != null) {
            ObjectClassDefinition ocd = null;
            try {
                ocd = provider.getObjectClassDefinition(metatype_pid, null);
                if (ocd != null) {
                    AttributeDefinition[] attr = ocd.getAttributeDefinitions(-1);
                    int i = 0;
                    while (i < attr.length) {
                        String id = attr[i].getID();
                        String label = attr[i].getName();
                        idToLabelMap.put(id, label);
                        ++i;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return idToLabelMap;
    }

    protected void doParentage(Data[] outData) {
        String parentage;
        if (outData != null && this.data != null && this.originalData != null && this.originalData.length == this.data.length) {
            int i = 0;
            while (i < outData.length) {
                Object parent;
                if (outData[i] != null && (parent = outData[i].getMetadata().get("Parent")) != null) {
                    int j = 0;
                    while (j < this.data.length) {
                        if (parent == this.data[j]) {
                            outData[i].getMetadata().put("Parent", this.originalData[j]);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((parentage = (String)this.serviceReference.getProperty("parentage")) != null && (parentage = parentage.trim()).equalsIgnoreCase("default") && this.originalData != null && this.originalData.length > 0 && this.originalData[0] != null) {
            int i = 0;
            while (i < outData.length) {
                if (outData[i] != null && outData[i].getMetadata().get("Parent") == null) {
                    outData[i].getMetadata().put("Parent", this.originalData[0]);
                }
                ++i;
            }
        }
    }

    private LogService getLogService() {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(DataManagerService.class.getName());
        LogService log = null;
        if (serviceReference != null) {
            log = (LogService)this.bundleContext.getService(this.bundleContext.getServiceReference(LogService.class.getName()));
        }
        return log;
    }

    private ConfigurationAdmin getConfigurationAdmin() {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        ConfigurationAdmin ca = null;
        if (serviceReference != null) {
            ca = (ConfigurationAdmin)this.bundleContext.getService(this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName()));
        }
        return ca;
    }

    private void logNullOCDWarning(String pid, String metatype_pid) {
        this.log(2, "Warning: could not get object class definition '" + metatype_pid + "' from the algorithm '" + pid + "'");
    }

    public ProgressMonitor getProgressMonitor() {
        if (this.algorithm instanceof ProgressTrackable) {
            return this.progressMonitor;
        }
        return null;
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }
}

