/*
 * Decompiled with CFR 0.152.
 */
package org.cishell.reference.gui.menumanager.menu;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.AlgorithmProperty;
import org.cishell.reference.gui.menumanager.menu.AlgorithmAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MenuAdapter
implements AlgorithmProperty {
    public static final String DEFAULT_MENU_FILE_NAME = "default_menu.xml";
    public static final String TAG_TOP_MENU = "top_menu";
    public static final String TAG_MENU = "menu";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PID_ATTRIBUTE = "pid";
    public static final String PRESERVED_GROUP = "group";
    public static final String PRESERVED_BREAK = "break";
    public static final String PRESERVED_EXIT = "Exit";
    public static final String PRESERVED_SERVICE_PID = "service.pid";
    public static final String PRESERVED = "preserved";
    public static final String HELP_DESK_EMAIL_ADDRESS = "nwb-helpdesk@googlegroups.com";
    private String toolName;
    private String toolTicketURL;
    private IMenuManager menuManager;
    private Shell shell;
    private BundleContext bundleContext;
    private CIShellContext ciShellContext;
    private Map<String, Action> algorithmsToActions;
    private Map<Action, IMenuManager> actionsToMenuManagers;
    private ContextListener contextListener;
    private IWorkbenchWindow workbenchWindow;
    private LogService logger;
    private Map<String, ServiceReference> pidsToServiceReferences;
    private Map<String, ServiceReference> pidsToServiceReferencesCopy;
    private Document documentObjectModel;
    private Runnable updateAction = new Runnable(){

        @Override
        public void run() {
            MenuAdapter.this.menuManager.updateAll(true);
        }
    };
    private Runnable stopAction = new Runnable(){

        @Override
        public void run() {
            String[] algorithmKeys = MenuAdapter.this.algorithmsToActions.keySet().toArray(new String[0]);
            int ii = 0;
            while (ii < algorithmKeys.length) {
                Action item = (Action)MenuAdapter.this.algorithmsToActions.get(algorithmKeys[ii]);
                IMenuManager targetMenu = (IMenuManager)MenuAdapter.this.actionsToMenuManagers.get(item);
                targetMenu.remove(item.getId());
                MenuAdapter.this.algorithmsToActions.remove(algorithmKeys[ii]);
                MenuAdapter.this.actionsToMenuManagers.remove(item);
                ++ii;
            }
        }
    };

    public MenuAdapter(String toolName, String toolTicketURL, IMenuManager menuManager, Shell shell, BundleContext bundleContext, CIShellContext ciShellContext, IWorkbenchWindow workbenchWindow) {
        this.toolName = toolName;
        this.toolTicketURL = toolTicketURL;
        this.menuManager = menuManager;
        this.shell = shell;
        this.bundleContext = bundleContext;
        this.ciShellContext = ciShellContext;
        this.workbenchWindow = workbenchWindow;
        this.algorithmsToActions = new HashMap<String, Action>();
        this.actionsToMenuManagers = new HashMap<Action, IMenuManager>();
        this.pidsToServiceReferences = new HashMap<String, ServiceReference>();
        this.pidsToServiceReferencesCopy = new HashMap<String, ServiceReference>();
        this.logger = (LogService)this.ciShellContext.getService(LogService.class.getName());
        String filter = "(objectClass=" + AlgorithmFactory.class.getName() + ")";
        this.contextListener = new ContextListener();
        try {
            bundleContext.addServiceListener((ServiceListener)this.contextListener, filter);
            this.preprocessServiceBundles();
            String applicationLocation = System.getProperty("osgi.configuration.area");
            String fileFullPath = String.valueOf(applicationLocation) + DEFAULT_MENU_FILE_NAME;
            URL configurationDirectoryURL = new URL(fileFullPath);
            try {
                configurationDirectoryURL.getContent();
                this.createMenuFromXML(fileFullPath);
                this.processLeftServiceBundles();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                this.initializeMenu();
            }
            Display.getDefault().asyncExec(this.updateAction);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.logger.log(4, "Invalid Syntax", (Throwable)invalidSyntaxException);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
    }

    private void preprocessServiceBundles() throws InvalidSyntaxException {
        ServiceReference[] serviceReferences = this.bundleContext.getAllServiceReferences(AlgorithmFactory.class.getName(), null);
        if (serviceReferences != null) {
            int ii = 0;
            while (ii < serviceReferences.length) {
                String path = (String)serviceReferences[ii].getProperty("menu_path");
                if (path != null) {
                    String pid = (String)serviceReferences[ii].getProperty(PRESERVED_SERVICE_PID);
                    this.pidsToServiceReferences.put(pid.toLowerCase().trim(), serviceReferences[ii]);
                    this.pidsToServiceReferencesCopy.put(pid.toLowerCase().trim(), serviceReferences[ii]);
                }
                ++ii;
            }
        }
    }

    private void createMenuFromXML(String menuFilePath) throws InvalidSyntaxException {
        this.parseXMLFile(menuFilePath);
        Element documentElement = this.documentObjectModel.getDocumentElement();
        NodeList topMenuList = documentElement.getElementsByTagName(TAG_TOP_MENU);
        if (topMenuList != null && topMenuList.getLength() > 0) {
            int ii = 0;
            while (ii < topMenuList.getLength()) {
                Element element = (Element)topMenuList.item(ii);
                this.processTopMenu(element);
                ++ii;
            }
        }
    }

    private void processTopMenu(Element topMenuNode) {
        String topMenuName = topMenuNode.getAttribute(NAME_ATTRIBUTE);
        MenuManager topMenuBar = (MenuManager)this.menuManager.findUsingPath(topMenuName);
        if (topMenuBar == null) {
            topMenuBar = new MenuManager(topMenuName, topMenuName.toLowerCase());
            this.menuManager.appendToGroup("additions", (IContributionItem)topMenuBar);
        }
        this.processSubMenu(topMenuNode, topMenuBar);
    }

    private void processSubMenu(Element menuNode, MenuManager parentMenuBar) {
        NodeList subMenuList = menuNode.getElementsByTagName(TAG_MENU);
        if (subMenuList != null && subMenuList.getLength() > 0) {
            int ii = 0;
            while (ii < subMenuList.getLength()) {
                Element element = (Element)subMenuList.item(ii);
                if (element.getParentNode().equals(menuNode)) {
                    String menuName;
                    String menuType = element.getAttribute(TYPE_ATTRIBUTE);
                    String algorithmPID = element.getAttribute(PID_ATTRIBUTE);
                    if ((menuType == null || menuType.length() == 0) && algorithmPID != null) {
                        this.processAMenuNode(element, parentMenuBar);
                    } else if (menuType.equalsIgnoreCase(PRESERVED_GROUP)) {
                        String groupName = element.getAttribute(NAME_ATTRIBUTE);
                        MenuManager groupMenuBar = new MenuManager(groupName, groupName.toLowerCase());
                        parentMenuBar.add((IContributionItem)groupMenuBar);
                        this.processSubMenu(element, groupMenuBar);
                    } else if (menuType.equalsIgnoreCase(PRESERVED_BREAK)) {
                        parentMenuBar.add((IContributionItem)new Separator());
                    } else if (menuType.equalsIgnoreCase(PRESERVED) && (menuName = element.getAttribute(NAME_ATTRIBUTE)).equalsIgnoreCase(PRESERVED_EXIT)) {
                        if (parentMenuBar.getId().equalsIgnoreCase("file")) {
                            parentMenuBar.add((IContributionItem)new GroupMarker("start"));
                            parentMenuBar.add((IContributionItem)new GroupMarker("additions"));
                            parentMenuBar.add((IContributionItem)new GroupMarker("end"));
                        }
                        ActionFactory.IWorkbenchAction exitAction = ActionFactory.QUIT.create(this.workbenchWindow);
                        parentMenuBar.add((IContributionItem)new Separator());
                        parentMenuBar.add((IAction)exitAction);
                    }
                }
                ++ii;
            }
            if (!parentMenuBar.getId().equalsIgnoreCase("file") && !parentMenuBar.getId().equalsIgnoreCase("help")) {
                parentMenuBar.add((IContributionItem)new GroupMarker("start"));
                parentMenuBar.add((IContributionItem)new GroupMarker("additions"));
                parentMenuBar.add((IContributionItem)new GroupMarker("end"));
            }
        }
    }

    private void processAMenuNode(Element menuNode, MenuManager parentMenuBar) {
        String menuName = menuNode.getAttribute(NAME_ATTRIBUTE);
        String pid = menuNode.getAttribute(PID_ATTRIBUTE);
        if (pid != null && pid.length() != 0) {
            if (this.pidsToServiceReferencesCopy.containsKey(pid.toLowerCase().trim())) {
                ServiceReference serviceReference = this.pidsToServiceReferencesCopy.get(pid.toLowerCase().trim());
                this.pidsToServiceReferences.remove(pid.toLowerCase().trim());
                AlgorithmAction action = new AlgorithmAction(serviceReference, this.bundleContext, this.ciShellContext);
                String menuLabel = (String)serviceReference.getProperty("label");
                if (menuName != null && menuName.trim().length() > 0) {
                    action.setText(menuName);
                    action.setId(this.getItemID(serviceReference));
                    parentMenuBar.add((IAction)action);
                    this.handleActionAccelerator(action, (IMenuManager)parentMenuBar, serviceReference);
                } else if (menuLabel != null && menuLabel.trim().length() > 0) {
                    action.setText(menuLabel);
                    action.setId(this.getItemID(serviceReference));
                    parentMenuBar.add((IAction)action);
                    this.handleActionAccelerator(action, (IMenuManager)parentMenuBar, serviceReference);
                }
            } else {
                String algorithmNotFoundFormat = "Oops!  %s tried to place an algorithm with the id '%s' on the menu, but the algorithm could not be found.";
                String algorithmNotFoundMessage = String.format(algorithmNotFoundFormat, this.toolName, pid);
                String contactInformationFormat = "If you see this error, please contact %s, or post a ticket on our bug tracker at: %s .";
                String contactInformationMessage = String.format(contactInformationFormat, HELP_DESK_EMAIL_ADDRESS, this.toolTicketURL);
                this.logger.log(4, algorithmNotFoundMessage);
                this.logger.log(4, contactInformationMessage);
            }
        }
    }

    private void parseXMLFile(String menuFilePath) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setCoalescing(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.documentObjectModel = documentBuilder.parse(menuFilePath);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException saxException) {
            saxException.printStackTrace();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private void processLeftServiceBundles() {
        if (!this.pidsToServiceReferences.isEmpty()) {
            for (String key : this.pidsToServiceReferences.keySet()) {
                ServiceReference serviceReference = this.pidsToServiceReferences.get(key);
                this.makeMenuItem(serviceReference);
            }
        }
    }

    private void initializeMenu() throws InvalidSyntaxException {
        ServiceReference[] serviceReferences = this.bundleContext.getAllServiceReferences(AlgorithmFactory.class.getName(), null);
        if (serviceReferences != null) {
            int ii = 0;
            while (ii < serviceReferences.length) {
                this.makeMenuItem(serviceReferences[ii]);
                ++ii;
            }
        }
    }

    private void makeMenuItem(ServiceReference serviceReference) {
        String path = (String)serviceReference.getProperty("menu_path");
        String[] items = null;
        if (path != null) {
            items = path.split("/");
        }
        IMenuManager menu = null;
        if (items != null && items.length > 1) {
            AlgorithmAction action = new AlgorithmAction(serviceReference, this.bundleContext, this.ciShellContext);
            action.setId(this.getItemID(serviceReference));
            IMenuManager targetMenu = this.menuManager;
            String group = items[items.length - 1];
            int ii = 0;
            while (ii < items.length - 1) {
                menu = targetMenu.findMenuUsingPath(items[ii]);
                if (menu == null && items[ii] != null) {
                    menu = targetMenu.findMenuUsingPath(items[ii].toLowerCase());
                }
                if (menu == null) {
                    menu = this.createMenu(items[ii], items[ii]);
                    targetMenu.appendToGroup("additions", (IContributionItem)menu);
                }
                targetMenu = menu;
                ++ii;
            }
            group = items[items.length - 1];
            IContributionItem groupItem = targetMenu.find(group);
            if (groupItem == null) {
                groupItem = new GroupMarker(group);
                targetMenu.appendToGroup("additions", groupItem);
            }
            targetMenu.appendToGroup(group, (IAction)action);
            this.handleActionAccelerator(action, targetMenu, serviceReference);
            targetMenu.appendToGroup(group, (IContributionItem)new Separator());
            this.algorithmsToActions.put(this.getItemID(serviceReference), action);
            this.actionsToMenuManagers.put(action, targetMenu);
            Display.getDefault().asyncExec(this.updateAction);
        } else {
            this.logger.log(4, "Bad menu path for Algorithm: " + serviceReference.getProperty("label"));
        }
    }

    private String getItemID(ServiceReference serviceReference) {
        return serviceReference.getProperty("PID:service.pid") + "-SID:" + serviceReference.getProperty("service.id");
    }

    private MenuManager createMenu(String name, String id) {
        MenuManager menu = new MenuManager(name, id);
        menu.add((IContributionItem)new GroupMarker("start"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new GroupMarker("end"));
        return menu;
    }

    private void updateMenuItem(ServiceReference serviceReference) {
        Action item = this.algorithmsToActions.get(this.getItemID(serviceReference));
        if (item != null) {
            this.logger.log(4, "updateMenuItem for " + this.getItemID(serviceReference));
            item.setText("" + serviceReference.getProperty("label"));
        }
    }

    private void removeMenuItem(ServiceReference serviceReference) {
        IMenuManager targetMenu;
        int index;
        String path = (String)serviceReference.getProperty("menu_path");
        final Action item = this.algorithmsToActions.get(this.getItemID(serviceReference));
        if (path != null && item != null && (index = path.lastIndexOf(47)) != -1 && (targetMenu = this.menuManager.findMenuUsingPath(path = path.substring(0, index))) != null) {
            if (!this.shell.isDisposed()) {
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        targetMenu.remove(item.getId());
                    }
                });
            }
            this.algorithmsToActions.remove(this.getItemID(serviceReference));
            this.actionsToMenuManagers.remove(item);
        }
    }

    public void stop() {
        this.bundleContext.removeServiceListener((ServiceListener)this.contextListener);
        if (!this.shell.isDisposed()) {
            this.shell.getDisplay().syncExec(this.stopAction);
        }
    }

    private void handleActionAccelerator(Action action, IMenuManager parentMenuBar, ServiceReference serviceReference) {
        action.setAccelerator(MenuAdapter.determineActionAcceleratorKeyCode(serviceReference, action));
    }

    private static int determineActionAcceleratorKeyCode(ServiceReference serviceReference, Action action) {
        String shortcutString = (String)serviceReference.getProperty("shortcut");
        if (shortcutString != null) {
            return Action.convertAccelerator((String)shortcutString);
        }
        return 0;
    }

    static void printElementAttributes(Document doc) {
        NodeList nl = doc.getElementsByTagName("*");
        int len = nl.getLength();
        int j = 0;
        while (j < len) {
            Element e = (Element)nl.item(j);
            System.err.println(String.valueOf(e.getTagName()) + ":");
            NamedNodeMap nnm = e.getAttributes();
            if (nnm != null) {
                int i = 0;
                while (i < nnm.getLength()) {
                    Node n = nnm.item(i);
                    String attrname = n.getNodeName();
                    String attrval = n.getNodeValue();
                    System.err.print(" " + attrname + " = " + attrval);
                    ++i;
                }
            }
            System.err.println();
            ++j;
        }
    }

    private class ContextListener
    implements ServiceListener {
        private ContextListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    MenuAdapter.this.makeMenuItem(event.getServiceReference());
                    break;
                }
                case 4: {
                    MenuAdapter.this.removeMenuItem(event.getServiceReference());
                    break;
                }
                case 2: {
                    MenuAdapter.this.updateMenuItem(event.getServiceReference());
                }
            }
        }
    }
}

